/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.runtime.system.persistence;

import java.util.Map;
import java.util.function.Function;
import org.apache.isis.core.runtime.system.persistence.DataNucleusApplicationComponents5;
import org.datanucleus.PersistenceNucleusContext;
import org.datanucleus.api.jdo.JDOPersistenceManagerFactory;
import org.datanucleus.store.StoreManager;
import org.datanucleus.store.federation.FederatedStoreManager;
import org.datanucleus.store.schema.SchemaAwareStoreManager;

enum DNStoreManagerType {
    SchemaAware,
    Federated,
    Other;

    private static final String[] knownSchemaAwareIfNotFederated;

    public static DNStoreManagerType typeOf(Map<String, String> datanucleusProps) {
        if (DNStoreManagerType.hasSecondaryDataStore(datanucleusProps)) {
            return Federated;
        }
        if (DNStoreManagerType.isKnownSchemaAwareStoreManagerIfNotFederated(datanucleusProps)) {
            return SchemaAware;
        }
        return DNStoreManagerType.probe(datanucleusProps, storeManager -> {
            if (storeManager instanceof SchemaAwareStoreManager) {
                return SchemaAware;
            }
            if (storeManager instanceof FederatedStoreManager) {
                return Federated;
            }
            return Other;
        });
    }

    public boolean isSchemaAware() {
        return this == SchemaAware;
    }

    private static boolean hasSecondaryDataStore(Map<String, String> datanucleusProps) {
        boolean hasSecondaryDataStore = datanucleusProps.keySet().stream().anyMatch(key -> key.startsWith("datanucleus.datastore."));
        return hasSecondaryDataStore;
    }

    private static boolean isKnownSchemaAwareStoreManagerIfNotFederated(Map<String, String> datanucleusProps) {
        String connectionUrl = datanucleusProps.get("javax.jdo.option.ConnectionURL");
        if (connectionUrl != null) {
            for (String magic : knownSchemaAwareIfNotFederated) {
                if (!connectionUrl.startsWith(magic)) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static DNStoreManagerType probe(Map<String, String> datanucleusProps, Function<StoreManager, DNStoreManagerType> categorizer) {
        try (JDOPersistenceManagerFactory probePmf = (JDOPersistenceManagerFactory)DataNucleusApplicationComponents5.newPersistenceManagerFactory(datanucleusProps);){
            PersistenceNucleusContext nucleusContext = probePmf.getNucleusContext();
            StoreManager storeManager = nucleusContext.getStoreManager();
            DNStoreManagerType dNStoreManagerType = categorizer.apply(storeManager);
            return dNStoreManagerType;
        }
    }

    static {
        knownSchemaAwareIfNotFederated = new String[]{"jdbc:hsqldb:", "jdbc:sqlserver:", "jdbc:h2:", "jdbc:mysql:", "jdbc:mariadb:", "jdbc:postgresql:", "jdbc:db2:"};
    }
}

