/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.applib.services.jdosupport;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.jdo.Extent;
import javax.jdo.JDOQLTypedQuery;
import javax.jdo.PersistenceManager;
import javax.jdo.datastore.JDOConnection;
import javax.jdo.query.BooleanExpression;
import org.apache.isis.applib.FatalException;
import org.apache.isis.applib.annotation.DomainService;
import org.apache.isis.applib.annotation.NatureOfService;
import org.apache.isis.applib.annotation.Programmatic;
import org.apache.isis.applib.services.jdosupport.IsisJdoSupport_v3_2;
import org.apache.isis.commons.internal.base._NullSafe;
import org.apache.isis.commons.internal.collections._Lists;
import org.apache.isis.commons.internal.collections._Maps;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.adapter.concurrency.ConcurrencyChecking;
import org.apache.isis.core.metamodel.services.ServicesInjector;
import org.apache.isis.core.runtime.persistence.ObjectPersistenceException;
import org.apache.isis.core.runtime.system.persistence.PersistenceSession;
import org.apache.isis.core.runtime.system.session.IsisSessionFactory;

@DomainService(nature=NatureOfService.DOMAIN, menuOrder="2147483647")
public class IsisJdoSupportDN5
implements IsisJdoSupport_v3_2 {
    @Inject
    IsisSessionFactory isisSessionFactory;

    @Programmatic
    public <T> T refresh(T domainObject) {
        ObjectAdapter adapter = this.getPersistenceSession().adapterFor(domainObject);
        this.getPersistenceSession().refreshRoot((Object)adapter);
        return domainObject;
    }

    @Programmatic
    public void ensureLoaded(Collection<?> domainObjects) {
        this.getPersistenceSession().getPersistenceManager().retrieveAll(domainObjects);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Programmatic
    public List<Map<String, Object>> executeSql(String sql) {
        try (JDOConnection dataStoreConnection = this.getJdoPersistenceManager().getDataStoreConnection();){
            Object connectionObj = dataStoreConnection.getNativeConnection();
            if (!(connectionObj instanceof Connection)) {
                List<Map<String, Object>> list = null;
                return list;
            }
            Connection connection = (Connection)connectionObj;
            List<Map<String, Object>> list = IsisJdoSupportDN5.executeSql(connection, sql);
            return list;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Programmatic
    public Integer executeUpdate(String sql) {
        try (JDOConnection dataStoreConnection = this.getJdoPersistenceManager().getDataStoreConnection();){
            Object connectionObj = dataStoreConnection.getNativeConnection();
            if (!(connectionObj instanceof Connection)) {
                Integer n = null;
                return n;
            }
            Connection connection = (Connection)connectionObj;
            Integer n = IsisJdoSupportDN5.executeUpdate(connection, sql);
            return n;
        }
    }

    private static List<Map<String, Object>> executeSql(Connection connection, String sql) {
        ArrayList rows = _Lists.newArrayList();
        try (Statement statement = connection.createStatement();){
            ResultSet rs = statement.executeQuery(sql);
            ResultSetMetaData rsmd = rs.getMetaData();
            while (rs.next()) {
                LinkedHashMap row = _Maps.newLinkedHashMap();
                int columnCount = rsmd.getColumnCount();
                for (int i = 0; i < columnCount; ++i) {
                    Object val = rs.getObject(i + 1);
                    row.put(rsmd.getColumnName(i + 1), val);
                }
                rows.add(row);
            }
        }
        catch (SQLException ex) {
            throw new ObjectPersistenceException("Failed to executeSql: " + sql, (Throwable)ex);
        }
        return rows;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static int executeUpdate(Connection connection, String sql) {
        try (Statement statement = connection.createStatement();){
            int n = statement.executeUpdate(sql);
            return n;
        }
        catch (SQLException ex) {
            throw new ObjectPersistenceException("Failed to executeSql: " + sql, (Throwable)ex);
        }
    }

    @Programmatic
    public void deleteAll(Class<?> ... pcClasses) {
        for (Class<?> pcClass : pcClasses) {
            Extent extent = this.getJdoPersistenceManager().getExtent(pcClass);
            List instances = _NullSafe.stream((Iterable)extent).collect(Collectors.toList());
            try {
                ConcurrencyChecking.executeWithConcurrencyCheckingDisabled(() -> {
                    this.getJdoPersistenceManager().deletePersistentAll((Collection)instances);
                    return null;
                });
            }
            catch (Exception ex) {
                throw new FatalException((Throwable)ex);
            }
        }
    }

    @Override
    @Programmatic
    public <T> List<T> executeQuery(Class<T> cls, BooleanExpression filter) {
        JDOQLTypedQuery query = this.newTypesafeQuery(cls);
        if (filter != null) {
            query = query.filter(filter);
        }
        return IsisJdoSupportDN5.executeListAndClose(query);
    }

    @Override
    @Programmatic
    public <T> T executeQueryUnique(Class<T> cls, BooleanExpression filter) {
        JDOQLTypedQuery query = this.newTypesafeQuery(cls);
        if (filter != null) {
            query = query.filter(filter);
        }
        return IsisJdoSupportDN5.executeUniqueAndClose(query);
    }

    @Override
    @Programmatic
    public <T> JDOQLTypedQuery<T> newTypesafeQuery(Class<T> cls) {
        return this.getJdoPersistenceManager().newJDOQLTypedQuery(cls);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T> List<T> executeListAndClose(JDOQLTypedQuery<T> query) {
        try {
            ArrayList list;
            List elements = query.executeList();
            ArrayList arrayList = list = _Lists.newArrayList((Collection)elements);
            return arrayList;
        }
        finally {
            query.closeAll();
        }
    }

    private static <T> T executeUniqueAndClose(JDOQLTypedQuery<T> query) {
        try {
            Object result;
            Object object = result = query.executeUnique();
            return (T)object;
        }
        finally {
            query.closeAll();
        }
    }

    protected PersistenceSession getPersistenceSession() {
        return this.isisSessionFactory.getCurrentSession().getPersistenceSession();
    }

    protected ServicesInjector getServicesInjector() {
        return this.isisSessionFactory.getServicesInjector();
    }

    @Programmatic
    public PersistenceManager getJdoPersistenceManager() {
        return this.getPersistenceSession().getPersistenceManager();
    }
}

