/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.schema.utils.jaxbadapters;

import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import org.apache.isis.applib.services.bookmark.Bookmark;
import org.apache.isis.applib.services.bookmark.BookmarkService;
import org.apache.isis.commons.internal.collections._Lists;
import org.apache.isis.schema.common.v1.OidDto;
import org.apache.isis.schema.common.v1.OidsDto;

public class PersistentEntitiesAdapter
extends XmlAdapter<OidsDto, List<Object>> {
    @Inject
    BookmarkService bookmarkService;

    public List<Object> unmarshal(OidsDto oidsDto) {
        ArrayList domainObjects = _Lists.newArrayList();
        for (OidDto oidDto : oidsDto.getOid()) {
            Bookmark bookmark = Bookmark.from(oidDto);
            Object domainObject = this.bookmarkService.lookup(bookmark, BookmarkService.FieldResetPolicy.DONT_REFRESH);
            domainObjects.add(domainObject);
        }
        return domainObjects;
    }

    public OidsDto marshal(List<Object> domainObjects) {
        if (domainObjects == null) {
            return null;
        }
        OidsDto oidsDto = new OidsDto();
        for (Object domainObject : domainObjects) {
            Bookmark bookmark = this.getBookmarkService().bookmarkFor(domainObject);
            oidsDto.getOid().add(bookmark.toOidDto());
        }
        return oidsDto;
    }

    protected BookmarkService getBookmarkService() {
        return this.bookmarkService;
    }
}

