/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.applib.value;

import java.io.IOException;
import java.io.Serializable;
import java.io.Writer;
import javax.activation.MimeType;
import javax.activation.MimeTypeParseException;
import org.apache.isis.applib.value.NamedWithMimeType;

public final class Clob
implements NamedWithMimeType,
Serializable {
    private static final long serialVersionUID = 8694189924062378527L;
    private final String name;
    private final MimeType mimeType;
    private final CharSequence chars;

    public Clob(String name, String primaryType, String subType, char[] chars) {
        this(name, primaryType, subType, new String(chars));
    }

    public Clob(String name, String mimeTypeBase, char[] chars) {
        this(name, mimeTypeBase, (CharSequence)new String(chars));
    }

    public Clob(String name, MimeType mimeType, char[] chars) {
        this(name, mimeType, (CharSequence)new String(chars));
    }

    public Clob(String name, String primaryType, String subType, CharSequence chars) {
        this(name, Clob.newMimeType(primaryType, subType), chars);
    }

    public Clob(String name, String mimeTypeBase, CharSequence chars) {
        this(name, Clob.newMimeType(mimeTypeBase), chars);
    }

    public Clob(String name, MimeType mimeType, CharSequence chars) {
        if (name == null) {
            throw new IllegalArgumentException("Name cannot be null");
        }
        if (mimeType == null) {
            throw new IllegalArgumentException("MimeType cannot be null");
        }
        if (name.contains(":")) {
            throw new IllegalArgumentException("Name cannot contain ':'");
        }
        if (chars == null) {
            throw new IllegalArgumentException("Chars cannot be null");
        }
        this.name = name;
        this.mimeType = mimeType;
        this.chars = chars;
    }

    private static MimeType newMimeType(String baseType) {
        try {
            return new MimeType(baseType);
        }
        catch (MimeTypeParseException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private static MimeType newMimeType(String primaryType, String subType) {
        try {
            return new MimeType(primaryType, subType);
        }
        catch (MimeTypeParseException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public MimeType getMimeType() {
        return this.mimeType;
    }

    public CharSequence getChars() {
        return this.chars;
    }

    public void writeCharsTo(Writer wr) throws IOException {
        if (wr != null && this.chars != null) {
            wr.append(this.chars);
        }
    }

    public String toString() {
        return this.getName() + " [" + this.getMimeType().getBaseType() + "]: " + this.getChars().length() + " chars";
    }
}

