/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.applib.util;

import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import org.apache.isis.commons.internal.base._Casts;
import org.apache.isis.commons.internal.collections._Maps;
import org.apache.isis.commons.internal.resources._Resources;

public class JaxbUtil {
    private static Map<Class<?>, JAXBContext> jaxbContextByClass = _Maps.newConcurrentHashMap();

    private JaxbUtil() {
    }

    public static <T> T fromXml(Reader reader, Class<T> dtoClass) {
        Unmarshaller un = null;
        try {
            un = JaxbUtil.jaxbContextFor(dtoClass).createUnmarshaller();
            return (T)_Casts.uncheckedCast((Object)un.unmarshal(reader));
        }
        catch (JAXBException e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> T fromXml(Class<?> contextClass, String resourceName, Charset charset, Class<T> dtoClass) throws IOException {
        String s = _Resources.loadAsString(contextClass, (String)resourceName, (Charset)charset);
        return JaxbUtil.fromXml(new StringReader(s), dtoClass);
    }

    public static <T> String toXml(T dto) {
        CharArrayWriter caw = new CharArrayWriter();
        JaxbUtil.toXml(dto, caw);
        return caw.toString();
    }

    public static <T> void toXml(T dto, Writer writer) {
        try {
            Class<?> aClass = dto.getClass();
            Marshaller m = JaxbUtil.jaxbContextFor(aClass).createMarshaller();
            m.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            m.marshal(dto, writer);
        }
        catch (JAXBException e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> JAXBContext jaxbContextFor(Class<T> dtoClass) {
        return jaxbContextByClass.computeIfAbsent(dtoClass, JaxbUtil::contextOf);
    }

    private static <T> JAXBContext contextOf(Class<T> dtoClass) {
        try {
            return JAXBContext.newInstance((Class[])new Class[]{dtoClass});
        }
        catch (JAXBException e) {
            throw new RuntimeException(e);
        }
    }
}

