/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.applib.util;

import java.util.stream.Collectors;
import org.apache.isis.commons.internal.base._Strings;

public final class Enums {
    private Enums() {
    }

    public static String getFriendlyNameOf(Enum<?> anEnum) {
        return Enums.getFriendlyNameOf(anEnum.name());
    }

    public static String getFriendlyNameOf(String anEnumName) {
        return _Strings.splitThenStream((String)anEnumName, (String)"_").map(_Strings::lower).map(_Strings::capitalize).collect(Collectors.joining(" "));
    }

    public static String getEnumNameFromFriendly(String anEnumFriendlyName) {
        return _Strings.splitThenStream((String)anEnumFriendlyName, (String)" ").map(_Strings::upper).collect(Collectors.joining("_"));
    }

    public static String enumToHttpHeader(Enum<?> anEnum) {
        return Enums.enumNameToHttpHeader(anEnum.name());
    }

    public static String enumNameToHttpHeader(String name) {
        StringBuilder builder = new StringBuilder();
        boolean nextUpper = true;
        for (char c : name.toCharArray()) {
            if (c == '_') {
                nextUpper = true;
                builder.append("-");
                continue;
            }
            builder.append(nextUpper ? c : Character.toLowerCase(c));
            nextUpper = false;
        }
        return builder.toString();
    }

    public static String enumToCamelCase(Enum<?> anEnum) {
        return Enums.enumNameToCamelCase(anEnum.name());
    }

    private static String enumNameToCamelCase(String name) {
        StringBuilder builder = new StringBuilder();
        boolean nextUpper = false;
        for (char c : name.toCharArray()) {
            if (c == '_') {
                nextUpper = true;
                continue;
            }
            builder.append(nextUpper ? c : Character.toLowerCase(c));
            nextUpper = false;
        }
        return builder.toString();
    }
}

