/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.applib.tree;

import java.util.Arrays;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.isis.applib.tree.TreePath;

class TreePath_Default
implements TreePath {
    private static final long serialVersionUID = 530511373409525896L;
    private final int[] canonicalPath;
    private final int hashCode;

    TreePath_Default(int[] canonicalPath) {
        Objects.requireNonNull(canonicalPath, "canonicalPath is required");
        if (canonicalPath.length < 1) {
            throw new IllegalArgumentException("canonicalPath must not be empty");
        }
        this.canonicalPath = canonicalPath;
        this.hashCode = Arrays.hashCode(canonicalPath);
    }

    @Override
    public TreePath append(int indexWithinSiblings) {
        int[] newCanonicalPath = new int[this.canonicalPath.length + 1];
        System.arraycopy(this.canonicalPath, 0, newCanonicalPath, 0, this.canonicalPath.length);
        newCanonicalPath[this.canonicalPath.length] = indexWithinSiblings;
        return new TreePath_Default(newCanonicalPath);
    }

    @Override
    public TreePath getParentIfAny() {
        if (this.isRoot()) {
            return null;
        }
        int[] newCanonicalPath = new int[this.canonicalPath.length - 1];
        System.arraycopy(this.canonicalPath, 0, newCanonicalPath, 0, this.canonicalPath.length - 1);
        return new TreePath_Default(newCanonicalPath);
    }

    @Override
    public boolean isRoot() {
        return this.canonicalPath.length == 1;
    }

    public boolean equals(Object obj) {
        if (obj instanceof TreePath_Default) {
            TreePath_Default other = (TreePath_Default)obj;
            return Arrays.equals(this.canonicalPath, other.canonicalPath);
        }
        return false;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public String toString() {
        return "/" + IntStream.of(this.canonicalPath).mapToObj(i -> "" + i).collect(Collectors.joining("/"));
    }
}

