/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.applib.tree;

import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Stack;
import org.apache.isis.applib.tree.TreeNode;

class TreeNode_iteratorDepthFirst<T>
implements Iterator<TreeNode<T>> {
    private Stack<TreeNode<T>> stack = new Stack();
    private TreeNode<T> next;
    private Stack<TreeNode<T>> fifo = new Stack();

    TreeNode_iteratorDepthFirst(TreeNode<T> treeNode) {
        this.next = treeNode;
    }

    @Override
    public boolean hasNext() {
        return this.next != null;
    }

    @Override
    public TreeNode<T> next() {
        if (this.next == null) {
            throw new NoSuchElementException("Iterator has run out of elements.");
        }
        TreeNode<T> result = this.next;
        this.next = this.fetchNext(this.next);
        return result;
    }

    private TreeNode<T> fetchNext(TreeNode<T> current) {
        if (!current.isLeaf()) {
            this.pushChildrenToStackInReverseOrder(current);
        }
        return this.stack.isEmpty() ? null : this.stack.pop();
    }

    private void pushChildrenToStackInReverseOrder(TreeNode<T> node) {
        node.streamChildren().forEach(this.fifo::push);
        while (!this.fifo.isEmpty()) {
            this.stack.push(this.fifo.pop());
        }
    }
}

