/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.applib.tree;

import java.util.Objects;
import java.util.concurrent.atomic.LongAdder;
import java.util.stream.Stream;
import org.apache.isis.applib.annotation.Value;
import org.apache.isis.applib.tree.TreeAdapter;
import org.apache.isis.applib.tree.TreeNode;
import org.apache.isis.applib.tree.TreePath;
import org.apache.isis.applib.tree.TreeState;
import org.apache.isis.commons.internal.base._Lazy;
import org.apache.isis.commons.internal.exceptions._Exceptions;

@Value(semanticsProviderName="org.apache.isis.core.metamodel.facets.value.treenode.TreeNodeValueSemanticsProvider")
public class LazyTreeNode<T>
implements TreeNode<T> {
    private final TreeState sharedState;
    private final T value;
    private final Class<? extends TreeAdapter<T>> treeAdapterClass;
    private final _Lazy<TreeAdapter<T>> treeAdapter = _Lazy.of(this::newTreeAdapter);
    private final _Lazy<TreePath> treePath = _Lazy.of(this::resolveTreePath);

    public static <T> TreeNode<T> of(T value, Class<? extends TreeAdapter<T>> treeAdapterClass, TreeState sharedState) {
        return new LazyTreeNode<T>(value, treeAdapterClass, sharedState);
    }

    protected LazyTreeNode(T value, Class<? extends TreeAdapter<T>> treeAdapterClass, TreeState sharedState) {
        this.value = Objects.requireNonNull(value);
        this.treeAdapterClass = Objects.requireNonNull(treeAdapterClass);
        this.sharedState = sharedState;
    }

    @Override
    public T getValue() {
        return this.value;
    }

    @Override
    public TreeNode<T> getParentIfAny() {
        return this.treeAdapter().parentOf(this.getValue()).map(this::toTreeNode).orElse(null);
    }

    @Override
    public int getChildCount() {
        return this.treeAdapter().childCountOf(this.value);
    }

    @Override
    public Stream<TreeNode<T>> streamChildren() {
        if (this.isLeaf()) {
            return Stream.empty();
        }
        return this.treeAdapter().childrenOf(this.value).map(this::toTreeNode);
    }

    @Override
    public Class<? extends TreeAdapter<T>> getTreeAdapterClass() {
        return this.treeAdapterClass;
    }

    @Override
    public TreePath getPositionAsPath() {
        return (TreePath)this.treePath.get();
    }

    @Override
    public TreeState getTreeState() {
        return this.sharedState;
    }

    private TreeAdapter<T> newTreeAdapter() {
        try {
            return this.treeAdapterClass.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new IllegalArgumentException(String.format("failed to instantiate TreeAdapter '%s'", this.treeAdapterClass.getName()), e);
        }
    }

    private TreeAdapter<T> treeAdapter() {
        return (TreeAdapter)this.treeAdapter.get();
    }

    private TreeNode<T> toTreeNode(T value) {
        return LazyTreeNode.of(value, this.getTreeAdapterClass(), this.sharedState);
    }

    private TreePath resolveTreePath() {
        TreeNode<T> parent = this.getParentIfAny();
        if (parent == null) {
            return TreePath.root();
        }
        return parent.getPositionAsPath().append(this.indexWithinSiblings(parent));
    }

    private int indexWithinSiblings(TreeNode<T> parent) {
        LongAdder indexOneBased = new LongAdder();
        boolean found = parent.streamChildren().peek(__ -> indexOneBased.increment()).anyMatch(sibling -> this.equals(sibling));
        if (!found) {
            throw _Exceptions.unexpectedCodeReach();
        }
        return indexOneBased.intValue() - 1;
    }
}

