/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.applib.services.swagger;

import javax.inject.Inject;
import org.apache.isis.applib.IsisApplibModule;
import org.apache.isis.applib.annotation.Action;
import org.apache.isis.applib.annotation.ActionLayout;
import org.apache.isis.applib.annotation.DomainService;
import org.apache.isis.applib.annotation.DomainServiceLayout;
import org.apache.isis.applib.annotation.MemberOrder;
import org.apache.isis.applib.annotation.NatureOfService;
import org.apache.isis.applib.annotation.ParameterLayout;
import org.apache.isis.applib.annotation.RestrictTo;
import org.apache.isis.applib.annotation.SemanticsOf;
import org.apache.isis.applib.services.swagger.SwaggerService;
import org.apache.isis.applib.services.swagger.Util;
import org.apache.isis.applib.value.Clob;
import org.apache.isis.applib.value.LocalResourcePath;
import org.apache.isis.commons.internal.resources._Resources;

@DomainService(nature=NatureOfService.VIEW_MENU_ONLY, objectType="isisApplib.SwaggerServiceMenu")
@DomainServiceLayout(named="Prototyping", menuBar=DomainServiceLayout.MenuBar.SECONDARY, menuOrder="500.600")
public class SwaggerServiceMenu {
    @Inject
    SwaggerService swaggerService;

    @Action(semantics=SemanticsOf.SAFE, domainEvent=OpenSwaggerUiDomainEvent.class, restrictTo=RestrictTo.PROTOTYPING)
    @ActionLayout(cssClassFa="fa-external-link")
    @MemberOrder(sequence="500.600.1")
    public LocalResourcePath openSwaggerUi() {
        return new LocalResourcePath("/swagger-ui/index.template.html");
    }

    @Action(semantics=SemanticsOf.SAFE, domainEvent=OpenSwaggerUiDomainEvent.class, restrictTo=RestrictTo.PROTOTYPING)
    @ActionLayout(cssClassFa="fa-external-link")
    @MemberOrder(sequence="500.600.2")
    public LocalResourcePath openRestApi() {
        return new LocalResourcePath("/" + _Resources.getRestfulPathIfAny() + "/");
    }

    @Action(semantics=SemanticsOf.SAFE, domainEvent=DownloadSwaggerSpecDomainEvent.class, restrictTo=RestrictTo.PROTOTYPING)
    @ActionLayout(cssClassFa="fa-download")
    @MemberOrder(sequence="500.600.3")
    public Clob downloadSwaggerSchemaDefinition(@ParameterLayout(named="Filename") String fileNamePrefix, SwaggerService.Visibility visibility, SwaggerService.Format format) {
        String fileName = Util.buildFileName(fileNamePrefix, visibility, format);
        String spec = this.swaggerService.generateSwaggerSpec(visibility, format);
        return new Clob(fileName, format.mediaType(), (CharSequence)spec);
    }

    public String default0DownloadSwaggerSchemaDefinition() {
        return "swagger";
    }

    public SwaggerService.Visibility default1DownloadSwaggerSchemaDefinition() {
        return SwaggerService.Visibility.PRIVATE;
    }

    public SwaggerService.Format default2DownloadSwaggerSchemaDefinition() {
        return SwaggerService.Format.YAML;
    }

    public static class DownloadSwaggerSpecDomainEvent
    extends ActionDomainEvent {
        private static final long serialVersionUID = 1L;
    }

    public static class OpenRestApiDomainEvent
    extends ActionDomainEvent {
        private static final long serialVersionUID = 1L;
    }

    public static class OpenSwaggerUiDomainEvent
    extends ActionDomainEvent {
        private static final long serialVersionUID = 1L;
    }

    public static abstract class ActionDomainEvent
    extends IsisApplibModule.ActionDomainEvent<SwaggerServiceMenu> {
        private static final long serialVersionUID = 1L;
    }
}

