/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.applib.services.session;

import java.util.Date;
import org.apache.isis.applib.annotation.Programmatic;

public interface SessionLoggingService {
    @Programmatic
    public void log(Type var1, String var2, Date var3, CausedBy var4, String var5);

    public static class Stderr
    implements SessionLoggingService {
        @Override
        public void log(Type type, String username, Date date, CausedBy causedBy, String sessionId) {
            StringBuilder logMessage = new StringBuilder();
            logMessage.append("User '").append(username);
            logMessage.append("' with sessionId '").append(sessionId).append("' has logged ");
            if (type == Type.LOGIN) {
                logMessage.append("in");
            } else {
                logMessage.append("out");
            }
            logMessage.append(" at '").append(date).append("'.");
            if (causedBy == CausedBy.SESSION_EXPIRATION) {
                logMessage.append("Cause: session expiration");
            }
            System.err.println(logMessage);
        }
    }

    public static enum CausedBy {
        USER,
        SESSION_EXPIRATION,
        RESTART;

    }

    public static enum Type {
        LOGIN,
        LOGOUT;

    }
}

