/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.applib.services.registry;

import java.util.Optional;
import java.util.stream.Stream;
import org.apache.isis.applib.annotation.Programmatic;

public interface ServiceRegistry {
    @Programmatic
    public <T> T injectServicesInto(T var1);

    @Programmatic
    public Stream<Object> streamServices();

    @Programmatic
    public <T> Stream<T> streamServices(Class<T> var1);

    @Programmatic
    default public <T> Optional<T> lookupService(Class<T> serviceClass) {
        return this.streamServices(serviceClass).findFirst();
    }

    @Programmatic
    default public boolean isService(Class<?> serviceClass) {
        return this.lookupService(serviceClass).isPresent();
    }

    @Programmatic
    default public <T> T lookupServiceElseFail(Class<T> serviceClass) {
        return this.streamServices(serviceClass).findFirst().orElseThrow(() -> new IllegalStateException("Could not locate service of type '" + serviceClass + "'"));
    }
}

