/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.applib.services.metamodel;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.isis.applib.AppManifest;
import org.apache.isis.applib.AppManifest2;
import org.apache.isis.applib.annotation.Programmatic;
import org.apache.isis.applib.services.bookmark.Bookmark;
import org.apache.isis.applib.services.command.CommandDtoProcessor;
import org.apache.isis.applib.services.metamodel.DomainModel;
import org.apache.isis.commons.internal.collections._Lists;
import org.apache.isis.schema.metamodel.v1.MetamodelDto;

public interface MetaModelService {
    @Programmatic
    public Class<?> fromObjectType(String var1);

    @Programmatic
    public String toObjectType(Class<?> var1);

    @Programmatic
    public void rebuild(Class<?> var1);

    @Programmatic
    public DomainModel getDomainModel();

    @Programmatic
    public Sort sortOf(Class<?> var1, Mode var2);

    @Programmatic
    public Sort sortOf(Bookmark var1, Mode var2);

    @Programmatic
    public AppManifest2 getAppManifest2();

    @Programmatic
    public AppManifest getAppManifest();

    @Programmatic
    public CommandDtoProcessor commandDtoProcessorFor(String var1);

    @Programmatic
    public MetamodelDto exportMetaModel(Config var1);

    public static class Config {
        private static final int IGNORE_NOOP_FACETS = 1;
        private static final int IGNORE_INTERFACES = 2;
        private static final int IGNORE_ABSTRACT_CLASSES = 4;
        private static final int IGNORE_BUILT_IN_VALUE_TYPES = 8;
        private static final int IGNORE_MIXINS = 16;
        private final int mask;
        private final List<String> packagePrefixes;

        public Config() {
            this(0, Collections.emptyList());
        }

        private Config(int mask, List<String> packagePrefixes) {
            this.mask = mask;
            this.packagePrefixes = Collections.unmodifiableList(packagePrefixes);
        }

        private Config(int mask) {
            this(mask, null);
        }

        public Config withIgnoreNoop() {
            return this.newConfigWith(1);
        }

        public Config withIgnoreInterfaces() {
            return this.newConfigWith(2);
        }

        public Config withIgnoreAbstractClasses() {
            return this.newConfigWith(4);
        }

        public Config withIgnoreBuiltInValueTypes() {
            return this.newConfigWith(8);
        }

        public Config withIgnoreMixins() {
            return this.newConfigWith(16);
        }

        private Config newConfigWith(int x) {
            return new Config(this.mask | x, this.packagePrefixes);
        }

        public Config withPackagePrefix(String packagePrefix) {
            ArrayList prefixes = _Lists.newArrayList(this.packagePrefixes);
            prefixes.add(packagePrefix);
            return new Config(this.mask, prefixes);
        }

        public boolean isIgnoreNoop() {
            return this.hasFlag(1);
        }

        public boolean isIgnoreInterfaces() {
            return this.hasFlag(2);
        }

        public boolean isIgnoreAbstractClasses() {
            return this.hasFlag(4);
        }

        public boolean isIgnoreBuiltInValueTypes() {
            return this.hasFlag(8);
        }

        public boolean isIgnoreMixins() {
            return this.hasFlag(16);
        }

        public List<String> getPackagePrefixes() {
            return this.packagePrefixes;
        }

        private boolean hasFlag(int x) {
            return (this.mask & x) == x;
        }
    }

    public static enum Mode {
        STRICT,
        RELAXED;

    }

    public static enum Sort {
        VIEW_MODEL,
        JDO_ENTITY,
        DOMAIN_SERVICE,
        MIXIN,
        VALUE,
        COLLECTION,
        UNKNOWN;


        public boolean isDomainService() {
            return this == DOMAIN_SERVICE;
        }

        public boolean isMixin() {
            return this == MIXIN;
        }

        public boolean isViewModel() {
            return this == VIEW_MODEL;
        }

        public boolean isValue() {
            return this == VALUE;
        }

        public boolean isCollection() {
            return this == COLLECTION;
        }

        public boolean isJdoEntity() {
            return this == JDO_ENTITY;
        }

        public boolean isUnknown() {
            return this == UNKNOWN;
        }
    }
}

