/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.applib.services.jaxb;

import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.SchemaOutputResolver;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Result;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.isis.applib.services.jaxb.JaxbService;
import org.apache.isis.applib.services.jaxb.StreamResultWithWriter;
import org.apache.isis.commons.internal.collections._Lists;
import org.apache.isis.commons.internal.collections._Maps;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

class CatalogingSchemaOutputResolver
extends SchemaOutputResolver {
    private static final String SCHEMA_LOCATION_INCORRECT = "http://isis.apache.org/schema/common";
    private static final String SCHEMA_LOCATION_CORRECT = "http://isis.apache.org/schema/common/common.xsd";
    private final JaxbService.IsisSchemas isisSchemas;
    private final List<String> namespaceUris = _Lists.newArrayList();
    private Map<String, StreamResultWithWriter> schemaResultByNamespaceUri = _Maps.newLinkedHashMap();

    public CatalogingSchemaOutputResolver(JaxbService.IsisSchemas isisSchemas) {
        this.isisSchemas = isisSchemas;
    }

    public List<String> getNamespaceUris() {
        return this.namespaceUris;
    }

    public String getSchemaTextFor(String namespaceUri) {
        StreamResultWithWriter streamResult = this.schemaResultByNamespaceUri.get(namespaceUri);
        if (streamResult == null) {
            return null;
        }
        String xsd = streamResult.asString();
        try {
            DocumentBuilderFactory docBuildFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder parser = docBuildFactory.newDocumentBuilder();
            Document document = parser.parse(new InputSource(new StringReader(xsd)));
            Element el = document.getDocumentElement();
            CatalogingSchemaOutputResolver.replaceCommonSchemaLocationIfAny(el);
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            StringWriter writer = new StringWriter();
            transformer.transform(new DOMSource(document), new StreamResult(writer));
            xsd = writer.toString();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return xsd;
    }

    private static void replaceCommonSchemaLocationIfAny(Node node) {
        if (CatalogingSchemaOutputResolver.schemaLocationReplacedIn(node)) {
            return;
        }
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node currentNode = nodeList.item(i);
            if (currentNode.getNodeType() != 1) continue;
            CatalogingSchemaOutputResolver.replaceCommonSchemaLocationIfAny(currentNode);
        }
    }

    private static boolean schemaLocationReplacedIn(Node node) {
        String value;
        Element importEl;
        Attr schemaLocationAttr;
        if (node instanceof Element && (schemaLocationAttr = (importEl = (Element)node).getAttributeNode("schemaLocation")) != null && SCHEMA_LOCATION_INCORRECT.endsWith(value = schemaLocationAttr.getValue())) {
            schemaLocationAttr.setValue(SCHEMA_LOCATION_CORRECT);
            return true;
        }
        return false;
    }

    public Result createOutput(String namespaceUri, String suggestedFileName) throws IOException {
        StreamResultWithWriter result = new StreamResultWithWriter();
        result.setSystemId(namespaceUri);
        if (!this.isisSchemas.shouldIgnore(namespaceUri)) {
            this.namespaceUris.add(namespaceUri);
            this.schemaResultByNamespaceUri.put(namespaceUri, result);
        }
        return result;
    }

    public Map<String, String> asMap() {
        LinkedHashMap map = _Maps.newLinkedHashMap();
        List<String> namespaceUris = this.getNamespaceUris();
        for (String namespaceUri : namespaceUris) {
            map.put(namespaceUri, this.getSchemaTextFor(namespaceUri));
        }
        return Collections.unmodifiableMap(map);
    }
}

