/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.applib.services.iactn;

import java.sql.Timestamp;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.LongAdder;
import javax.inject.Inject;
import org.apache.isis.applib.annotation.Programmatic;
import org.apache.isis.applib.annotation.Value;
import org.apache.isis.applib.events.domain.AbstractDomainEvent;
import org.apache.isis.applib.events.domain.ActionDomainEvent;
import org.apache.isis.applib.events.domain.PropertyDomainEvent;
import org.apache.isis.applib.services.HasUniqueId;
import org.apache.isis.applib.services.clock.ClockService;
import org.apache.isis.applib.services.metrics.MetricsService;
import org.apache.isis.commons.internal.collections._Lists;
import org.apache.isis.commons.internal.collections._Maps;
import org.apache.isis.schema.common.v1.DifferenceDto;
import org.apache.isis.schema.common.v1.InteractionType;
import org.apache.isis.schema.common.v1.PeriodDto;
import org.apache.isis.schema.ixn.v1.ActionInvocationDto;
import org.apache.isis.schema.ixn.v1.MemberExecutionDto;
import org.apache.isis.schema.ixn.v1.MetricsDto;
import org.apache.isis.schema.ixn.v1.ObjectCountsDto;
import org.apache.isis.schema.ixn.v1.PropertyEditDto;
import org.apache.isis.schema.utils.MemberExecutionDtoUtils;
import org.apache.isis.schema.utils.jaxbadapters.JavaSqlTimestampXmlGregorianCalendarAdapter;

@Value
public class Interaction
implements HasUniqueId {
    private UUID interactionId;
    private final List<Execution<?, ?>> executionGraphs = _Lists.newArrayList();
    private Execution<?, ?> currentExecution;
    private Execution<?, ?> priorExecution;
    private final Map<String, LongAdder> maxBySequence = _Maps.newHashMap();
    @Inject
    MetricsService metricsService;
    @Inject
    ClockService clockService;

    @Override
    @Programmatic
    public UUID getUniqueId() {
        return this.interactionId;
    }

    @Programmatic
    public void setUniqueId(UUID transactionId) {
        this.interactionId = transactionId;
    }

    @Programmatic
    public Execution<?, ?> getPriorExecution() {
        return this.priorExecution;
    }

    @Programmatic
    public Object execute(MemberExecutor<ActionInvocation> memberExecutor, ActionInvocation actionInvocation) {
        this.push(actionInvocation);
        return this.executeInternal(memberExecutor, actionInvocation);
    }

    @Programmatic
    public Object execute(MemberExecutor<PropertyEdit> memberExecutor, PropertyEdit propertyEdit) {
        this.push(propertyEdit);
        return this.executeInternal(memberExecutor, propertyEdit);
    }

    private <T extends Execution<?, ?>> Object executeInternal(MemberExecutor<T> memberExecutor, T execution) {
        try {
            Object result = memberExecutor.execute(execution);
            execution.setReturned(result);
            Object object = result;
            return object;
        }
        catch (Exception ex) {
            this.currentExecution.setThrew(ex);
            throw ex;
        }
        finally {
            Timestamp completedAt = this.clockService.nowAsJavaSqlTimestamp();
            this.pop(completedAt);
        }
    }

    @Programmatic
    public Execution<?, ?> getCurrentExecution() {
        return this.currentExecution;
    }

    @Programmatic
    private Execution<?, ?> push(Execution<?, ?> execution) {
        if (this.currentExecution == null) {
            this.executionGraphs.add(execution);
        } else {
            execution.setParent(this.currentExecution);
        }
        this.moveCurrentTo(execution);
        return execution;
    }

    @Programmatic
    private Execution<?, ?> pop(Timestamp completedAt) {
        if (this.currentExecution == null) {
            throw new IllegalStateException("No current execution to pop");
        }
        Execution<?, ?> popped = this.currentExecution;
        popped.setCompletedAt(completedAt);
        this.moveCurrentTo(this.currentExecution.getParent());
        return popped;
    }

    private void moveCurrentTo(Execution<?, ?> newExecution) {
        this.priorExecution = this.currentExecution;
        this.currentExecution = newExecution;
    }

    @Programmatic
    public List<Execution<?, ?>> getExecutions() {
        return Collections.unmodifiableList(this.executionGraphs);
    }

    @Programmatic
    public void clear() {
        this.executionGraphs.clear();
    }

    @Programmatic
    public int next(String sequenceId) {
        LongAdder adder = this.maxBySequence.computeIfAbsent(sequenceId, this::newAdder);
        adder.increment();
        return adder.intValue();
    }

    private LongAdder newAdder(String ignore) {
        LongAdder adder = new LongAdder();
        adder.decrement();
        return adder;
    }

    public static class PropertyEdit
    extends Execution<PropertyEditDto, PropertyDomainEvent<?, ?>> {
        private final Object newValue;

        public PropertyEdit(Interaction interaction, String memberId, Object target, Object newValue, String targetMember, String targetClass) {
            super(interaction, InteractionType.PROPERTY_EDIT, memberId, target, targetMember, targetClass);
            this.newValue = newValue;
        }

        @Programmatic
        public Object getNewValue() {
            return this.newValue;
        }
    }

    public static class ActionInvocation
    extends Execution<ActionInvocationDto, ActionDomainEvent<?>> {
        private final List<Object> args;

        public ActionInvocation(Interaction interaction, String memberId, Object target, List<Object> args, String targetMember, String targetClass) {
            super(interaction, InteractionType.ACTION_INVOCATION, memberId, target, targetMember, targetClass);
            this.args = args;
        }

        @Programmatic
        public List<Object> getArgs() {
            return this.args;
        }
    }

    public static abstract class Execution<T extends MemberExecutionDto, E extends AbstractDomainEvent<?>> {
        private final String memberIdentifier;
        private final Object target;
        private final String targetMember;
        private final String targetClass;
        private final Interaction interaction;
        private final InteractionType interactionType;
        private final List<Execution<?, ?>> children = _Lists.newArrayList();
        private Execution<?, ?> parent;
        private E event;
        private Timestamp startedAt;
        private Timestamp completedAt;
        private Object returned;
        private Exception threw;
        private T dto;

        protected Execution(Interaction interaction, InteractionType interactionType, String memberIdentifier, Object target, String targetMember, String targetClass) {
            this.interaction = interaction;
            this.interactionType = interactionType;
            this.memberIdentifier = memberIdentifier;
            this.target = target;
            this.targetMember = targetMember;
            this.targetClass = targetClass;
        }

        @Programmatic
        public Interaction getInteraction() {
            return this.interaction;
        }

        @Programmatic
        public InteractionType getInteractionType() {
            return this.interactionType;
        }

        @Programmatic
        public String getMemberIdentifier() {
            return this.memberIdentifier;
        }

        @Programmatic
        public Object getTarget() {
            return this.target;
        }

        @Programmatic
        public String getTargetClass() {
            return this.targetClass;
        }

        @Programmatic
        public String getTargetMember() {
            return this.targetMember;
        }

        @Programmatic
        public Execution<?, ?> getParent() {
            return this.parent;
        }

        @Programmatic
        public void setParent(Execution<?, ?> parent) {
            this.parent = parent;
            if (parent != null) {
                parent.children.add(this);
            }
        }

        @Programmatic
        public List<Execution<?, ?>> getChildren() {
            return Collections.unmodifiableList(this.children);
        }

        @Programmatic
        public E getEvent() {
            return this.event;
        }

        @Programmatic
        public void setEvent(E event) {
            this.event = event;
        }

        @Programmatic
        public Timestamp getStartedAt() {
            return this.startedAt;
        }

        @Programmatic
        public void setStartedAt(Timestamp startedAt) {
            this.syncMetrics(When.BEFORE, startedAt);
        }

        @Programmatic
        public Timestamp getCompletedAt() {
            return this.completedAt;
        }

        void setCompletedAt(Timestamp completedAt) {
            this.syncMetrics(When.AFTER, completedAt);
        }

        @Programmatic
        public Object getReturned() {
            return this.returned;
        }

        @Programmatic
        public void setReturned(Object returned) {
            this.returned = returned;
        }

        @Programmatic
        public Exception getThrew() {
            return this.threw;
        }

        @Programmatic
        public void setThrew(Exception threw) {
            this.threw = threw;
        }

        @Programmatic
        public T getDto() {
            return this.dto;
        }

        @Programmatic
        public void setDto(T executionDto) {
            this.dto = executionDto;
        }

        private void syncMetrics(When when, Timestamp timestamp) {
            MetricsService metricsService = this.interaction.metricsService;
            int numberObjectsLoaded = metricsService.numberObjectsLoaded();
            int numberObjectsDirtied = metricsService.numberObjectsDirtied();
            when.syncMetrics(this, timestamp, numberObjectsLoaded, numberObjectsDirtied);
        }

        static enum When {
            BEFORE{

                @Override
                void syncMetrics(Execution<?, ?> execution, Timestamp timestamp, int numberObjectsLoaded, int numberObjectsDirtied) {
                    ((Execution)execution).startedAt = timestamp;
                    MetricsDto metricsDto = When.metricsFor(execution);
                    PeriodDto periodDto = When.timingsFor(metricsDto);
                    periodDto.setStartedAt(JavaSqlTimestampXmlGregorianCalendarAdapter.print((Timestamp)timestamp));
                    ObjectCountsDto objectCountsDto = When.objectCountsFor(metricsDto);
                    When.numberObjectsLoadedFor(objectCountsDto).setBefore(Integer.valueOf(numberObjectsLoaded));
                    When.numberObjectsDirtiedFor(objectCountsDto).setBefore(Integer.valueOf(numberObjectsDirtied));
                }
            }
            ,
            AFTER{

                @Override
                void syncMetrics(Execution<?, ?> execution, Timestamp timestamp, int numberObjectsLoaded, int numberObjectsDirtied) {
                    ((Execution)execution).completedAt = timestamp;
                    MetricsDto metricsDto = When.metricsFor(execution);
                    PeriodDto periodDto = When.timingsFor(metricsDto);
                    periodDto.setCompletedAt(JavaSqlTimestampXmlGregorianCalendarAdapter.print((Timestamp)timestamp));
                    ObjectCountsDto objectCountsDto = When.objectCountsFor(metricsDto);
                    When.numberObjectsLoadedFor(objectCountsDto).setAfter(Integer.valueOf(numberObjectsLoaded));
                    When.numberObjectsDirtiedFor(objectCountsDto).setAfter(Integer.valueOf(numberObjectsDirtied));
                }
            };


            private static DifferenceDto numberObjectsDirtiedFor(ObjectCountsDto objectCountsDto) {
                return MemberExecutionDtoUtils.numberObjectsDirtiedFor(objectCountsDto);
            }

            private static DifferenceDto numberObjectsLoadedFor(ObjectCountsDto objectCountsDto) {
                return MemberExecutionDtoUtils.numberObjectsLoadedFor(objectCountsDto);
            }

            private static ObjectCountsDto objectCountsFor(MetricsDto metricsDto) {
                return MemberExecutionDtoUtils.objectCountsFor(metricsDto);
            }

            private static MetricsDto metricsFor(Execution<?, ?> execution) {
                return MemberExecutionDtoUtils.metricsFor(((Execution)execution).dto);
            }

            private static PeriodDto timingsFor(MetricsDto metricsDto) {
                return MemberExecutionDtoUtils.timingsFor(metricsDto);
            }

            abstract void syncMetrics(Execution<?, ?> var1, Timestamp var2, int var3, int var4);
        }
    }

    public static enum Sequence {
        INTERACTION,
        PUBLISHED_EVENT,
        TRANSACTION;


        @Programmatic
        public String id() {
            return Sequence.class.getName() + "#" + this.name();
        }
    }

    public static interface MemberExecutor<T extends Execution<?, ?>> {
        @Programmatic
        public Object execute(T var1);
    }
}

