/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.applib.services.exceprecog;

import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.jdo.JDODataStoreException;
import org.apache.isis.applib.services.exceprecog.ExceptionRecognizer;
import org.apache.isis.applib.services.exceprecog.ExceptionRecognizerAbstract;
import org.apache.isis.commons.internal.exceptions._Exceptions;

public class ExceptionRecognizerForType
extends ExceptionRecognizerAbstract {
    protected static final Predicate<Throwable> ofTypeExcluding(Class<? extends Throwable> exceptionType, String ... messages) {
        return ExceptionRecognizerForType.ofType(exceptionType).and(ExceptionRecognizerForType.excluding(messages));
    }

    protected static final Predicate<Throwable> ofTypeIncluding(Class<? extends Throwable> exceptionType, String ... messages) {
        return ExceptionRecognizerForType.ofType(exceptionType).and(ExceptionRecognizerForType.including(messages));
    }

    protected static final Predicate<Throwable> ofType(Class<? extends Throwable> exceptionType) {
        return input -> exceptionType.isAssignableFrom(input.getClass());
    }

    protected static final Predicate<Throwable> excluding(String ... messages) {
        return input -> {
            List causalChain = _Exceptions.getCausalChain((Throwable)input);
            for (String message : messages) {
                for (Throwable throwable : causalChain) {
                    Throwable[] nestedExceptions;
                    String throwableMessage = throwable.getMessage();
                    if (throwableMessage != null && throwableMessage.contains(message)) {
                        return false;
                    }
                    if (!(throwable instanceof JDODataStoreException)) continue;
                    JDODataStoreException jdoDataStoreException = (JDODataStoreException)throwable;
                    for (Throwable nestedException : nestedExceptions = jdoDataStoreException.getNestedExceptions()) {
                        String nestedThrowableMessage = nestedException.getMessage();
                        if (nestedThrowableMessage == null || !nestedThrowableMessage.contains(message)) continue;
                        return false;
                    }
                }
            }
            return true;
        };
    }

    protected static final Predicate<Throwable> including(String ... messages) {
        return input -> {
            List causalChain = _Exceptions.getCausalChain((Throwable)input);
            for (String message : messages) {
                for (Throwable throwable : causalChain) {
                    String throwableMessage = throwable.getMessage();
                    if (throwableMessage == null || !throwableMessage.contains(message)) continue;
                    return true;
                }
            }
            return false;
        };
    }

    public ExceptionRecognizerForType(ExceptionRecognizer.Category category, Class<? extends Exception> exceptionType, Function<String, String> messageParser) {
        this(category, ExceptionRecognizerForType.ofType(exceptionType), messageParser);
    }

    public ExceptionRecognizerForType(ExceptionRecognizer.Category category, Predicate<Throwable> predicate, Function<String, String> messageParser) {
        super(category, predicate, messageParser);
    }

    public ExceptionRecognizerForType(ExceptionRecognizer.Category category, Class<? extends Exception> exceptionType) {
        this(category, exceptionType, null);
    }

    public ExceptionRecognizerForType(Class<? extends Exception> exceptionType, Function<String, String> messageParser) {
        this(ExceptionRecognizer.Category.OTHER, exceptionType, messageParser);
    }

    public ExceptionRecognizerForType(Predicate<Throwable> predicate, Function<String, String> messageParser) {
        this(ExceptionRecognizer.Category.OTHER, predicate, messageParser);
    }

    public ExceptionRecognizerForType(Class<? extends Exception> exceptionType) {
        this(ExceptionRecognizer.Category.OTHER, exceptionType);
    }
}

