/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.applib.services.exceprecog;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Stream;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.apache.isis.applib.annotation.Programmatic;
import org.apache.isis.applib.services.exceprecog.ExceptionRecognizer;
import org.apache.isis.applib.services.i18n.TranslationService;
import org.apache.isis.applib.services.registry.ServiceRegistry;
import org.apache.isis.commons.internal.collections._Lists;

public class ExceptionRecognizerComposite
implements ExceptionRecognizer {
    private final List<ExceptionRecognizer> exceptionRecognizers = _Lists.newArrayList();
    @Inject
    ServiceRegistry serviceRegistry;
    @Inject
    TranslationService translationService;

    public ExceptionRecognizerComposite(ExceptionRecognizer ... exceptionRecognizers) {
        this(Arrays.asList(exceptionRecognizers));
    }

    public ExceptionRecognizerComposite(List<? extends ExceptionRecognizer> exceptionRecognizers) {
        for (ExceptionRecognizer exceptionRecognizer : exceptionRecognizers) {
            this.add(exceptionRecognizer);
        }
    }

    public ExceptionRecognizerComposite(Stream<? extends ExceptionRecognizer> exceptionRecognizers) {
        exceptionRecognizers.forEach(this::add);
    }

    @Programmatic
    public final void add(ExceptionRecognizer ers) {
        this.exceptionRecognizers.add(ers);
    }

    @Override
    @Programmatic
    public final String recognize(Throwable ex) {
        for (ExceptionRecognizer ers : this.exceptionRecognizers) {
            String message = ers.recognize(ex);
            if (message == null) continue;
            return message;
        }
        return null;
    }

    @Override
    @Programmatic
    public final ExceptionRecognizer.Recognition recognize2(Throwable ex) {
        for (ExceptionRecognizer ers : this.exceptionRecognizers) {
            ExceptionRecognizer.Recognition recognition = ers.recognize2(ex);
            if (recognition == null) continue;
            return recognition;
        }
        return ExceptionRecognizer.Recognition.of(ExceptionRecognizer.Category.OTHER, this.recognize(ex));
    }

    @Override
    @PostConstruct
    @Programmatic
    public void init() {
        this.injectServices();
        this.initRecognizers();
    }

    protected void injectServices() {
        if (this.serviceRegistry != null) {
            for (ExceptionRecognizer ers : this.exceptionRecognizers) {
                this.serviceRegistry.injectServicesInto(ers);
            }
        }
    }

    protected void initRecognizers() {
        for (ExceptionRecognizer ers : this.exceptionRecognizers) {
            ers.init();
        }
    }

    @Override
    @PreDestroy
    @Programmatic
    public void shutdown() {
        for (ExceptionRecognizer ers : this.exceptionRecognizers) {
            ers.shutdown();
        }
    }
}

