/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.applib.services.exceprecog;

import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.apache.isis.applib.annotation.Programmatic;
import org.apache.isis.applib.services.exceprecog.ExceptionRecognizer;
import org.apache.isis.applib.services.exceprecog.TranslatableException;
import org.apache.isis.applib.services.i18n.TranslatableString;
import org.apache.isis.applib.services.i18n.TranslationService;
import org.apache.isis.commons.internal.exceptions._Exceptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ExceptionRecognizerAbstract
implements ExceptionRecognizer {
    public static final Logger LOG = LoggerFactory.getLogger(ExceptionRecognizerAbstract.class);
    private static final String KEY_LOG_RECOGNIZED_EXCEPTIONS = "isis.services.exceprecog.logRecognizedExceptions";
    private final ExceptionRecognizer.Category category;
    private final Predicate<Throwable> predicate;
    private final Function<String, String> messageParser;
    private boolean logRecognizedExceptions;
    @Inject
    protected TranslationService translationService;

    protected static Function<String, String> constant(final String message) {
        return new Function<String, String>(){

            @Override
            public String apply(String input) {
                return message;
            }
        };
    }

    protected static Function<String, String> prefix(final String prefix) {
        return new Function<String, String>(){

            @Override
            public String apply(String input) {
                return prefix + ": " + input;
            }
        };
    }

    public ExceptionRecognizerAbstract(ExceptionRecognizer.Category category, Predicate<Throwable> predicate, Function<String, String> messageParser) {
        Objects.requireNonNull(predicate);
        this.category = category;
        this.predicate = predicate;
        this.messageParser = messageParser != null ? messageParser : Function.identity();
    }

    public ExceptionRecognizerAbstract(Predicate<Throwable> predicate, Function<String, String> messageParser) {
        this(ExceptionRecognizer.Category.OTHER, predicate, messageParser);
    }

    public ExceptionRecognizerAbstract(ExceptionRecognizer.Category category, Predicate<Throwable> predicate) {
        this(category, predicate, null);
    }

    public ExceptionRecognizerAbstract(Predicate<Throwable> predicate) {
        this(ExceptionRecognizer.Category.OTHER, predicate);
    }

    @Override
    @PostConstruct
    public void init() {
    }

    @Override
    @PreDestroy
    public void shutdown() {
    }

    @Override
    @Programmatic
    public String recognize(Throwable ex) {
        return _Exceptions.streamCausalChain((Throwable)ex).filter(this.predicate).map(throwable -> {
            if (this.logRecognizedExceptions) {
                LOG.info("Recognized exception, stacktrace : ", throwable);
            }
            if (ex instanceof TranslatableException) {
                TranslatableException translatableException = (TranslatableException)((Object)ex);
                TranslatableString translatableMessage = translatableException.getTranslatableMessage();
                String translationContext = translatableException.getTranslationContext();
                if (translatableMessage != null && translationContext != null) {
                    return translatableMessage.translate(this.translationService, translationContext);
                }
            }
            Throwable rootCause = _Exceptions.getRootCause((Throwable)throwable);
            String rootCauseMessage = rootCause.getMessage();
            String parsedMessage = this.messageParser.apply(rootCauseMessage);
            return parsedMessage;
        }).findFirst().orElse(null);
    }

    @Override
    @Programmatic
    public ExceptionRecognizer.Recognition recognize2(Throwable ex) {
        return ExceptionRecognizer.Recognition.of(this.category, this.recognize(ex));
    }
}

