/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.applib.services.eventbus;

import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.apache.isis.applib.annotation.Programmatic;
import org.apache.isis.commons.internal.collections._Sets;
import org.apache.isis.core.plugins.eventbus.EventBusPlugin;

public abstract class EventBusService {
    public static final EventBusService NOOP = new Noop();
    private final Set<Object> subscribers = _Sets.newConcurrentHashSet();
    private boolean hasPosted;
    protected EventBusPlugin eventBusImplementation;
    private Set<Object> registeredSubscribers;

    @Programmatic
    @PostConstruct
    public void init() {
        this.hasPosted = false;
    }

    @Programmatic
    @PreDestroy
    public void shutdown() {
        this.teardownEventBus();
    }

    @Programmatic
    public void register(Object domainService) {
        this.doRegister(domainService);
    }

    protected void doRegister(Object domainService) {
        if (this.eventBusImplementation == null) {
            this.subscribers.add(domainService);
        } else {
            this.eventBusImplementation.register(domainService);
        }
    }

    @Programmatic
    public void unregister(Object domainService) {
    }

    @Programmatic
    public Set<Object> getSubscribers() {
        return Collections.unmodifiableSet(_Sets.newLinkedHashSet(this.subscribers));
    }

    @Programmatic
    public void post(Object event) {
        if (this.skip(event)) {
            return;
        }
        this.hasPosted = true;
        this.getEventBusImplementation().post(event);
    }

    protected boolean hasPosted() {
        return this.hasPosted;
    }

    public <T> EventBusPlugin.EventListener<T> addEventListener(Class<T> targetType, Consumer<T> onEvent) {
        return Optional.ofNullable(this.getEventBusImplementation()).map(impl -> impl.addEventListener(targetType, onEvent)).orElse(null);
    }

    public <T> void removeEventListener(EventBusPlugin.EventListener<T> eventListener) {
        if (this.eventBusImplementation != null) {
            this.eventBusImplementation.removeEventListener(eventListener);
        }
    }

    @Programmatic
    protected EventBusPlugin getEventBusImplementation() {
        this.setupEventBus();
        return this.eventBusImplementation;
    }

    protected void setupEventBus() {
        if (this.eventBusImplementation != null) {
            return;
        }
        this.eventBusImplementation = this.newEventBus();
        this.registeredSubscribers = this.getSubscribers();
        for (Object subscriber : this.registeredSubscribers) {
            this.eventBusImplementation.register(subscriber);
        }
    }

    protected void teardownEventBus() {
        if (this.registeredSubscribers != null) {
            for (Object subscriber : this.registeredSubscribers) {
                this.eventBusImplementation.unregister(subscriber);
            }
        }
        this.eventBusImplementation = null;
    }

    protected abstract EventBusPlugin newEventBus();

    protected boolean skip(Object event) {
        return false;
    }

    public static class Noop
    extends EventBusService {
        @Override
        public void register(Object domainService) {
        }

        @Override
        public void unregister(Object domainService) {
        }

        @Override
        public void post(Object event) {
        }

        @Override
        public EventBusPlugin getEventBusImplementation() {
            return null;
        }

        @Override
        protected EventBusPlugin newEventBus() {
            return null;
        }
    }
}

