/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.applib.services.classdiscovery;

import java.util.Collections;
import java.util.Set;
import org.apache.isis.applib.AbstractService;
import org.apache.isis.applib.AppManifest;
import org.apache.isis.applib.annotation.DomainService;
import org.apache.isis.applib.annotation.NatureOfService;
import org.apache.isis.applib.annotation.Programmatic;
import org.apache.isis.applib.fixturescripts.FixtureScript;
import org.apache.isis.applib.services.classdiscovery.ClassDiscoveryService;
import org.apache.isis.commons.internal.base._Casts;
import org.apache.isis.core.plugins.classdiscovery.ClassDiscoveryPlugin;

@DomainService(nature=NatureOfService.DOMAIN, menuOrder="2147483647")
public class ClassDiscoveryServiceDefault
extends AbstractService
implements ClassDiscoveryService {
    @Override
    @Programmatic
    public <T> Set<Class<? extends T>> findSubTypesOfClasses(Class<T> type, String packageNamePrefix) {
        if (type == FixtureScript.class) {
            return ClassDiscoveryServiceDefault.getFixtureScriptTypes();
        }
        return ClassDiscoveryPlugin.get().discoverFullscan(packageNamePrefix).getSubTypesOf(type);
    }

    private static <T> Set<Class<? extends T>> getFixtureScriptTypes() {
        Set<Class<? extends FixtureScript>> fixtureScriptTypes = AppManifest.Registry.instance().getFixtureScriptTypes();
        if (fixtureScriptTypes != null) {
            return (Set)_Casts.uncheckedCast(fixtureScriptTypes);
        }
        return Collections.emptySet();
    }
}

