/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.applib.services.bookmark;

import java.io.Serializable;
import java.util.Iterator;
import org.apache.isis.applib.annotation.Value;
import org.apache.isis.commons.internal.base._Strings;
import org.apache.isis.commons.internal.exceptions._Exceptions;
import org.apache.isis.schema.common.v1.BookmarkObjectState;
import org.apache.isis.schema.common.v1.OidDto;

@Value
public class Bookmark
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected static final String SEPARATOR = ":";
    protected final String objectType;
    private final String identifier;
    protected final ObjectState state;

    public static Bookmark create(String str) {
        return str != null ? new Bookmark(str) : null;
    }

    public OidDto toOidDto() {
        OidDto oidDto = new OidDto();
        oidDto.setType(this.getObjectType());
        oidDto.setId(this.getIdentifier());
        BookmarkObjectState bookmarkState = this.getObjectState().toBookmarkState();
        oidDto.setObjectState((BookmarkObjectState)(bookmarkState != BookmarkObjectState.PERSISTENT ? bookmarkState : null));
        return oidDto;
    }

    public static Bookmark from(OidDto oidDto) {
        BookmarkObjectState bookmarkObjectState = oidDto.getObjectState();
        ObjectState objectState = ObjectState.from(bookmarkObjectState);
        String objectType = Bookmark.coalesce(oidDto.getType(), oidDto.getObjectType());
        String objectId = Bookmark.coalesce(oidDto.getId(), oidDto.getObjectIdentifier());
        Bookmark bookmark = new Bookmark(objectState.getCode() + objectType, objectId);
        return bookmark;
    }

    private static String coalesce(String first, String second) {
        return first != null ? first : second;
    }

    public Bookmark(String toString) {
        this(_Strings.splitThenStream((String)toString, (String)SEPARATOR).iterator());
    }

    private Bookmark(Iterator<String> split) {
        this(split.next(), split.next());
    }

    public Bookmark(String objectType, String identifier) {
        this.state = ObjectState.from(objectType);
        this.objectType = this.state != ObjectState.PERSISTENT ? objectType.substring(1) : objectType;
        this.identifier = identifier;
    }

    public ObjectState getObjectState() {
        return this.state;
    }

    public String getObjectType() {
        return this.objectType;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.identifier == null ? 0 : this.identifier.hashCode());
        result = 31 * result + (this.objectType == null ? 0 : this.objectType.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Bookmark other = (Bookmark)obj;
        if (this.identifier == null ? other.identifier != null : !this.identifier.equals(other.identifier)) {
            return false;
        }
        return !(this.objectType == null ? other.objectType != null : !this.objectType.equals(other.objectType));
    }

    public String toString() {
        return this.state.getCode() + this.objectType + SEPARATOR + this.identifier;
    }

    public static class AsStringType {
        private AsStringType() {
        }

        public static class Meta {
            public static final int MAX_LEN = 2000;

            private Meta() {
            }
        }
    }

    public static enum ObjectState {
        PERSISTENT("", BookmarkObjectState.PERSISTENT),
        TRANSIENT("!", BookmarkObjectState.TRANSIENT),
        VIEW_MODEL("*", BookmarkObjectState.VIEW_MODEL);

        private final String code;
        private final BookmarkObjectState bookmarkObjectState;

        private ObjectState(String code, BookmarkObjectState bookmarkObjectState) {
            this.code = code;
            this.bookmarkObjectState = bookmarkObjectState;
        }

        public boolean isTransient() {
            return this == TRANSIENT;
        }

        public boolean isViewModel() {
            return this == VIEW_MODEL;
        }

        public boolean isPersistent() {
            return this == PERSISTENT;
        }

        public String getCode() {
            return this.code;
        }

        public static ObjectState from(String objectType) {
            if (objectType.startsWith(ObjectState.TRANSIENT.code)) {
                return TRANSIENT;
            }
            if (objectType.startsWith(ObjectState.VIEW_MODEL.code)) {
                return VIEW_MODEL;
            }
            return PERSISTENT;
        }

        public static ObjectState from(BookmarkObjectState objectState) {
            if (objectState == null) {
                return PERSISTENT;
            }
            switch (objectState) {
                case TRANSIENT: {
                    return TRANSIENT;
                }
                case VIEW_MODEL: {
                    return VIEW_MODEL;
                }
                case PERSISTENT: {
                    return PERSISTENT;
                }
            }
            throw _Exceptions.unmatchedCase((Object)objectState);
        }

        public BookmarkObjectState toBookmarkState() {
            return this.bookmarkObjectState;
        }
    }
}

