/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.applib.mixins.dto;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.activation.MimeType;
import javax.activation.MimeTypeParseException;
import javax.inject.Inject;
import org.apache.isis.applib.FatalException;
import org.apache.isis.applib.IsisApplibModule;
import org.apache.isis.applib.annotation.Action;
import org.apache.isis.applib.annotation.ActionLayout;
import org.apache.isis.applib.annotation.Contributed;
import org.apache.isis.applib.annotation.MemberOrder;
import org.apache.isis.applib.annotation.Mixin;
import org.apache.isis.applib.annotation.ParameterLayout;
import org.apache.isis.applib.annotation.RestrictTo;
import org.apache.isis.applib.annotation.SemanticsOf;
import org.apache.isis.applib.mixins.dto.Dto;
import org.apache.isis.applib.mixins.dto.Util;
import org.apache.isis.applib.services.jaxb.JaxbService;
import org.apache.isis.applib.services.message.MessageService;
import org.apache.isis.applib.value.Blob;
import org.apache.isis.applib.value.Clob;

@Mixin(method="act")
public class Dto_downloadXsd {
    private final Dto dto;
    private final MimeType mimeTypeApplicationZip;
    @Inject
    MessageService messageService;
    @Inject
    JaxbService jaxbService;

    public Dto_downloadXsd(Dto dto) {
        this.dto = dto;
        try {
            this.mimeTypeApplicationZip = new MimeType("application", "zip");
        }
        catch (MimeTypeParseException ex) {
            throw new FatalException(ex);
        }
    }

    @Action(domainEvent=ActionDomainEvent.class, semantics=SemanticsOf.SAFE, restrictTo=RestrictTo.PROTOTYPING)
    @ActionLayout(contributed=Contributed.AS_ACTION, cssClassFa="fa-download")
    @MemberOrder(sequence="500.2")
    public Object act(@ParameterLayout(named="File name") String fileName, JaxbService.IsisSchemas isisSchemas) {
        Map<String, String> map = this.jaxbService.toXsd(this.dto, isisSchemas);
        if (map.isEmpty()) {
            this.messageService.warnUser(String.format("No schemas were generated for %s; programming error?", this.dto.getClass().getName()));
            return null;
        }
        if (map.size() == 1) {
            Map.Entry<String, String> entry = map.entrySet().iterator().next();
            return new Clob(Util.withSuffix(fileName, "xsd"), "text/xml", (CharSequence)entry.getValue());
        }
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ZipOutputStream zos = new ZipOutputStream(baos);
            OutputStreamWriter writer = new OutputStreamWriter(zos);
            for (Map.Entry<String, String> entry : map.entrySet()) {
                String namespaceUri = entry.getKey();
                String schemaText = entry.getValue();
                zos.putNextEntry(new ZipEntry(Dto_downloadXsd.zipEntryNameFor(namespaceUri)));
                writer.write(schemaText);
                writer.flush();
                zos.closeEntry();
            }
            writer.close();
            return new Blob(Util.withSuffix(fileName, "zip"), this.mimeTypeApplicationZip, baos.toByteArray());
        }
        catch (IOException ex) {
            throw new FatalException("Unable to create zip", ex);
        }
    }

    public String default0Act() {
        return Util.withSuffix(this.dto.getClass().getName(), "xsd");
    }

    public JaxbService.IsisSchemas default1Act() {
        return JaxbService.IsisSchemas.IGNORE;
    }

    private static String zipEntryNameFor(String namespaceUri) {
        return Util.withSuffix(namespaceUri, "xsd");
    }

    public static class ActionDomainEvent
    extends IsisApplibModule.ActionDomainEvent<Dto_downloadXsd> {
        private static final long serialVersionUID = 1L;
    }
}

