/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.applib.mixins.dto;

import javax.inject.Inject;
import org.apache.isis.applib.annotation.DomainService;
import org.apache.isis.applib.annotation.NatureOfService;
import org.apache.isis.applib.annotation.Programmatic;
import org.apache.isis.applib.services.bookmark.Bookmark;
import org.apache.isis.applib.services.bookmark.BookmarkService;
import org.apache.isis.commons.internal.exceptions._Exceptions;
import org.apache.isis.schema.common.v1.BookmarkObjectState;
import org.apache.isis.schema.common.v1.OidDto;

@DomainService(nature=NatureOfService.DOMAIN)
public class DtoMappingHelper {
    @Inject
    BookmarkService bookmarkService;

    @Programmatic
    public OidDto oidDtoFor(Object object) {
        Bookmark bookmark = this.bookmarkService.bookmarkFor(object);
        return DtoMappingHelper.asOidDto(bookmark);
    }

    private static OidDto asOidDto(Bookmark reference) {
        OidDto argValue;
        if (reference != null) {
            argValue = new OidDto();
            argValue.setObjectType(reference.getObjectType());
            argValue.setObjectState(DtoMappingHelper.bookmarkObjectStateOf(reference));
            argValue.setObjectIdentifier(reference.getIdentifier());
        } else {
            argValue = null;
        }
        return argValue;
    }

    private static BookmarkObjectState bookmarkObjectStateOf(Bookmark bookmark) {
        switch (bookmark.getObjectState()) {
            case PERSISTENT: {
                return BookmarkObjectState.PERSISTENT;
            }
            case TRANSIENT: {
                return BookmarkObjectState.TRANSIENT;
            }
            case VIEW_MODEL: {
                return BookmarkObjectState.VIEW_MODEL;
            }
        }
        throw _Exceptions.unmatchedCase((String)"objectState '%s' not recognized", (Object)((Object)bookmark.getObjectState()));
    }
}

