/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.applib.layout.menubars.bootstrap3;

import java.util.List;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.isis.applib.annotation.DomainServiceLayout;
import org.apache.isis.applib.layout.component.ServiceActionLayoutData;
import org.apache.isis.applib.layout.menubars.MenuBars;
import org.apache.isis.applib.layout.menubars.MenuBarsAbstract;
import org.apache.isis.applib.layout.menubars.bootstrap3.BS3Menu;
import org.apache.isis.applib.layout.menubars.bootstrap3.BS3MenuBar;
import org.apache.isis.applib.layout.menubars.bootstrap3.BS3MenuSection;
import org.apache.isis.commons.internal.exceptions._Exceptions;

@XmlRootElement(name="menuBars")
@XmlType(name="menuBars", propOrder={"primary", "secondary", "tertiary", "metadataError"})
public class BS3MenuBars
extends MenuBarsAbstract {
    private static final long serialVersionUID = 1L;
    private BS3MenuBar primary = new BS3MenuBar();
    private BS3MenuBar secondary = new BS3MenuBar();
    private BS3MenuBar tertiary = new BS3MenuBar();
    private String metadataError;

    public BS3MenuBar getPrimary() {
        return this.primary;
    }

    public void setPrimary(BS3MenuBar primary) {
        this.primary = primary;
    }

    public BS3MenuBar getSecondary() {
        return this.secondary;
    }

    public void setSecondary(BS3MenuBar secondary) {
        this.secondary = secondary;
    }

    public BS3MenuBar getTertiary() {
        return this.tertiary;
    }

    public void setTertiary(BS3MenuBar tertiary) {
        this.tertiary = tertiary;
    }

    @Override
    public BS3MenuBar menuBarFor(DomainServiceLayout.MenuBar menuBar) {
        switch (menuBar) {
            case PRIMARY: {
                return this.getPrimary();
            }
            case SECONDARY: {
                return this.getSecondary();
            }
            case TERTIARY: {
                return this.getTertiary();
            }
            case NOT_SPECIFIED: {
                break;
            }
            default: {
                throw _Exceptions.unmatchedCase((Object)((Object)menuBar));
            }
        }
        return null;
    }

    @Override
    public void visit(MenuBars.Visitor visitor) {
        this.traverseMenuBar(this.getPrimary(), visitor);
        this.traverseMenuBar(this.getSecondary(), visitor);
        this.traverseMenuBar(this.getTertiary(), visitor);
    }

    private void traverseMenuBar(BS3MenuBar menuBar, MenuBars.Visitor visitor) {
        Visitor bs3Visitor;
        Visitor visitor2 = bs3Visitor = visitor instanceof Visitor ? (Visitor)visitor : null;
        if (bs3Visitor != null) {
            bs3Visitor.preVisit(menuBar);
            bs3Visitor.visit(menuBar);
        }
        for (BS3Menu menu : menuBar.getMenus()) {
            this.traverseMenu(menu, visitor);
        }
        if (bs3Visitor != null) {
            bs3Visitor.postVisit(menuBar);
        }
    }

    private void traverseMenu(BS3Menu menu, MenuBars.Visitor visitor) {
        Visitor bs3Visitor;
        Visitor visitor2 = bs3Visitor = visitor instanceof Visitor ? (Visitor)visitor : null;
        if (bs3Visitor != null) {
            bs3Visitor.preVisit(menu);
            bs3Visitor.visit(menu);
        }
        List<BS3MenuSection> sections = menu.getSections();
        for (BS3MenuSection section : sections) {
            this.traverseSection(section, visitor);
        }
        if (bs3Visitor != null) {
            bs3Visitor.postVisit(menu);
        }
    }

    private void traverseSection(BS3MenuSection section, MenuBars.Visitor visitor) {
        Visitor bs3Visitor;
        Visitor visitor2 = bs3Visitor = visitor instanceof Visitor ? (Visitor)visitor : null;
        if (bs3Visitor != null) {
            bs3Visitor.preVisit(section);
            bs3Visitor.visit(section);
        }
        List<ServiceActionLayoutData> actions = section.getServiceActions();
        for (ServiceActionLayoutData action : actions) {
            visitor.visit(action);
        }
        if (bs3Visitor != null) {
            bs3Visitor.postVisit(section);
        }
    }

    @XmlElement(required=false)
    public String getMetadataError() {
        return this.metadataError;
    }

    public void setMetadataError(String metadataError) {
        this.metadataError = metadataError;
    }

    public static class VisitorAdapter
    implements Visitor {
        @Override
        public void preVisit(BS3MenuBar menuBar) {
        }

        @Override
        public void visit(BS3MenuBar menuBar) {
        }

        @Override
        public void postVisit(BS3MenuBar menuBar) {
        }

        @Override
        public void preVisit(BS3Menu menu) {
        }

        @Override
        public void visit(BS3Menu menu) {
        }

        @Override
        public void postVisit(BS3Menu menu) {
        }

        @Override
        public void preVisit(BS3MenuSection menuSection) {
        }

        @Override
        public void visit(BS3MenuSection section) {
        }

        @Override
        public void postVisit(BS3MenuSection menuSection) {
        }

        @Override
        public void visit(ServiceActionLayoutData serviceActionLayoutData) {
        }
    }

    public static interface Visitor
    extends MenuBars.Visitor {
        public void preVisit(BS3MenuBar var1);

        public void visit(BS3MenuBar var1);

        public void postVisit(BS3MenuBar var1);

        public void preVisit(BS3Menu var1);

        public void visit(BS3Menu var1);

        public void postVisit(BS3Menu var1);

        public void preVisit(BS3MenuSection var1);

        public void visit(BS3MenuSection var1);

        public void postVisit(BS3MenuSection var1);
    }
}

