/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.applib.fixturescripts.setup;

import java.util.List;
import org.apache.isis.applib.annotation.Programmatic;
import org.apache.isis.applib.fixturescripts.BuilderScriptAbstract;
import org.apache.isis.applib.fixturescripts.FixtureScript;
import org.apache.isis.applib.fixturescripts.FixtureScriptWithExecutionStrategy;
import org.apache.isis.applib.fixturescripts.FixtureScripts;
import org.apache.isis.applib.fixturescripts.PersonaWithBuilderScript;
import org.apache.isis.commons.internal.collections._Lists;

@Programmatic
public class PersonaEnumPersistAll<E extends Enum<E>, T, F extends BuilderScriptAbstract<T, F>>
extends FixtureScript
implements FixtureScriptWithExecutionStrategy {
    private final Class<E> personaEnumClass;
    private Integer number;
    private final List<T> objects = _Lists.newArrayList();

    public PersonaEnumPersistAll(Class<E> personaEnumClass) {
        this.personaEnumClass = personaEnumClass;
    }

    public Integer getNumber() {
        return this.number;
    }

    public void setNumber(Integer number) {
        this.number = number;
    }

    public List<T> getObjects() {
        return this.objects;
    }

    @Override
    protected void execute(FixtureScript.ExecutionContext ec) {
        Enum[] enumConstants = (Enum[])this.personaEnumClass.getEnumConstants();
        int max = enumConstants.length;
        int number = this.defaultParam("number", ec, max);
        if (number < 0 || number > max) {
            throw new IllegalArgumentException(String.format("number must be in range [0,%d)", max));
        }
        for (int i = 0; i < number; ++i) {
            Object enumFixture = ((PersonaWithBuilderScript)((Object)enumConstants[i])).builder();
            Object domainObject = ((BuilderScriptAbstract)ec.executeChildT((FixtureScript)this, enumFixture)).getObject();
            ec.addResult(this, domainObject);
            this.objects.add(domainObject);
        }
    }

    @Override
    public FixtureScripts.MultipleExecutionStrategy getMultipleExecutionStrategy() {
        return FixtureScripts.MultipleExecutionStrategy.EXECUTE_ONCE_BY_VALUE;
    }
}

