/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.applib.fixtures;

import java.sql.Timestamp;
import java.util.Calendar;
import java.util.TimeZone;
import org.apache.isis.applib.clock.Clock;

public class TickingFixtureClock
extends Clock {
    private static final TimeZone UTC_TIME_ZONE;
    static Clock existingInstance;
    private final Calendar calendar = Calendar.getInstance();
    private long t0 = 0L;

    public static synchronized TickingFixtureClock replaceExisting() {
        Clock instance = TickingFixtureClock.getInstance();
        if (instance instanceof TickingFixtureClock) {
            return (TickingFixtureClock)instance;
        }
        long time = Clock.getTime();
        existingInstance = Clock.instance;
        Clock.remove();
        return new TickingFixtureClock(time);
    }

    public static boolean reinstateExisting() {
        Clock.instance = existingInstance;
        return true;
    }

    private TickingFixtureClock(long time) {
        this.calendar.setTimeZone(UTC_TIME_ZONE);
        this.calendar.setTimeInMillis(time);
        this.t0 = System.currentTimeMillis();
    }

    private long getOffset() {
        return System.currentTimeMillis() - this.t0;
    }

    @Override
    protected long time() {
        return this.calendar.getTime().getTime() + this.getOffset();
    }

    public void setTime(int hour, int min) {
        this.calendar.set(11, hour);
        this.calendar.set(12, min);
        this.calendar.set(13, 0);
        this.calendar.set(14, 0);
        this.t0 = System.currentTimeMillis();
    }

    public void setTime(Timestamp timestamp) {
        this.setTime(timestamp.getTime());
    }

    public void setTime(long millis) {
        this.calendar.setTimeInMillis(millis);
        this.t0 = System.currentTimeMillis();
    }

    public void setDate(int year, int month, int day) {
        this.calendar.set(1, year);
        this.calendar.set(2, month - 1);
        this.calendar.set(5, day);
        this.t0 = System.currentTimeMillis();
    }

    public void addTime(int hours, int minutes) {
        this.calendar.add(11, hours);
        this.calendar.add(12, minutes);
    }

    public void addDate(int years, int months, int days) {
        this.calendar.add(1, years);
        this.calendar.add(2, months);
        this.calendar.add(5, days);
    }

    public String toString() {
        return Clock.getTimeAsDateTime().toString();
    }

    static {
        TimeZone tempTimeZone = TimeZone.getTimeZone("Etc/UTC");
        if (tempTimeZone == null) {
            tempTimeZone = TimeZone.getTimeZone("UTC");
        }
        UTC_TIME_ZONE = tempTimeZone;
    }
}

