/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.applib.clock;

import java.sql.Timestamp;
import java.util.TimeZone;
import org.apache.isis.applib.Defaults;
import org.apache.isis.applib.clock.SystemClock;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.LocalDate;
import org.joda.time.LocalDateTime;

public abstract class Clock {
    protected static Clock instance;

    public static final Clock getInstance() {
        if (!Clock.isInitialized()) {
            instance = new SystemClock();
        }
        return instance;
    }

    public static boolean isInitialized() {
        return instance != null;
    }

    public static long getTime() {
        return Clock.getInstance().time();
    }

    public static LocalDate getTimeAsLocalDate() {
        DateTimeZone timeZone = DateTimeZone.forTimeZone((TimeZone)TimeZone.getDefault());
        return new LocalDate(Clock.getTime(), timeZone);
    }

    public static LocalDateTime getTimeAsLocalDateTime() {
        return new LocalDateTime(Clock.getTime(), Defaults.getTimeZone());
    }

    public static DateTime getTimeAsDateTime() {
        return new DateTime(Clock.getTime(), Defaults.getTimeZone());
    }

    public static Timestamp getTimeAsJavaSqlTimestamp() {
        return new Timestamp(Clock.getTimeAsMillis());
    }

    public static long getTimeAsMillis() {
        return Clock.getTimeAsDateTime().getMillis();
    }

    protected static boolean remove() {
        if (instance == null) {
            return false;
        }
        instance = null;
        return true;
    }

    protected Clock() {
        instance = this;
    }

    protected abstract long time();
}

