/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.applib.client.log;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.annotation.Priority;
import javax.ws.rs.client.ClientRequestContext;
import javax.ws.rs.client.ClientRequestFilter;
import javax.ws.rs.client.ClientResponseContext;
import javax.ws.rs.client.ClientResponseFilter;
import org.apache.isis.commons.internal.base._Strings;

@Priority(value=999)
public class RestfulLoggingFilter
implements ClientRequestFilter,
ClientResponseFilter {
    private static final Logger LOG = Logger.getLogger(RestfulLoggingFilter.class.getName());
    private final String basicAuthMagic = "Authorization=[Basic ";

    public void filter(ClientRequestContext requestContext) throws IOException {
        Exception acceptableMediaTypeParsingFailure;
        String endpoint = requestContext.getUri().toString();
        String method = requestContext.getMethod();
        try {
            String acceptableMediaTypes = requestContext.getAcceptableMediaTypes().toString();
            acceptableMediaTypeParsingFailure = null;
        }
        catch (Exception e) {
            acceptableMediaTypeParsingFailure = e;
        }
        String acceptHeaderParsing = acceptableMediaTypeParsingFailure != null ? "Failed to parse accept header, cause: " + acceptableMediaTypeParsingFailure.getMessage() : "OK";
        String headers = requestContext.getStringHeaders().entrySet().stream().map(entry -> entry.toString()).map(this::obscureAuthHeader).collect(Collectors.joining(",\n\t"));
        String requestBody = requestContext.getEntity().toString();
        StringBuilder sb = new StringBuilder();
        sb.append("\n").append("---------- JAX-RS REQUEST -------------\n").append("uri: ").append(endpoint).append("\n").append("method: ").append(method).append("\n").append("accept-header-parsing: ").append(acceptHeaderParsing).append("\n").append("headers: \n\t").append(headers).append("\n").append("request-body: ").append(requestBody).append("\n").append("----------------------------------------\n");
        LOG.log(Level.INFO, sb.toString());
    }

    public void filter(ClientRequestContext requestContext, ClientResponseContext responseContext) throws IOException {
        String responseBody;
        InputStream inputStream = responseContext.getEntityStream();
        if (inputStream != null) {
            responseBody = _Strings.read((InputStream)responseContext.getEntityStream(), (Charset)StandardCharsets.UTF_8);
            responseContext.setEntityStream((InputStream)new ByteArrayInputStream(responseBody.getBytes(StandardCharsets.UTF_8)));
        } else {
            responseBody = "null";
        }
        StringBuilder sb = new StringBuilder();
        sb.append("\n").append("---------- JAX-RS RESPONSE -------------\n").append("response-body: ").append(responseBody).append("\n").append("----------------------------------------\n");
        LOG.log(Level.INFO, sb.toString());
    }

    String obscureAuthHeader(String keyValueLiteral) {
        if (_Strings.isEmpty((CharSequence)keyValueLiteral)) {
            return keyValueLiteral;
        }
        if (keyValueLiteral.startsWith("Authorization=[Basic ")) {
            String obscured = _Strings.padEnd((String)"Authorization=[Basic ", (int)(keyValueLiteral.length() - 1), (char)'*') + "]";
            return obscured;
        }
        return keyValueLiteral;
    }
}

