/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.applib.client;

import java.util.EnumSet;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.core.Response;
import org.apache.isis.applib.client.ActionParameterListBuilder;
import org.apache.isis.applib.client.ResponseDigest;
import org.apache.isis.applib.client.RestfulClientConfig;
import org.apache.isis.applib.client.SuppressionType;
import org.apache.isis.applib.client.auth.BasicAuthFilter;
import org.apache.isis.applib.client.log.RestfulLoggingFilter;
import org.apache.isis.commons.internal.base._NullSafe;
import org.apache.isis.commons.internal.base._Strings;
import org.apache.isis.commons.internal.context._Context;

public class RestfulClient {
    private static final Logger LOG = Logger.getLogger(RestfulClient.class.getName());
    public static String DEFAULT_RESPONSE_CONTENT_TYPE = "application/json;profile=\"urn:org.apache.isis/v1\"";
    private RestfulClientConfig clientConfig;
    private Client client;

    public static RestfulClient ofConfig(RestfulClientConfig clientConfig) {
        RestfulClient restClient = new RestfulClient();
        restClient.init(clientConfig);
        return restClient;
    }

    public void init(RestfulClientConfig clientConfig) {
        this.clientConfig = clientConfig;
        this.client = ClientBuilder.newClient();
        this.registerDefaultJsonProvider();
        this.registerBasicAuthFilter();
        this.registerRequestDebugLoggingFilter();
    }

    public RestfulClientConfig getConfig() {
        return this.clientConfig;
    }

    public Client getJaxRsClient() {
        return this.client;
    }

    public Invocation.Builder request(String path, SuppressionType ... suppressionTypes) {
        return this.request(path, SuppressionType.setOf(suppressionTypes));
    }

    public Invocation.Builder request(String path, EnumSet<SuppressionType> suppressionTypes) {
        String responseContentType = DEFAULT_RESPONSE_CONTENT_TYPE + this.toSuppressionLiteral(suppressionTypes);
        return this.client.target(this.relativePathToUri(path)).request(new String[]{responseContentType});
    }

    public ActionParameterListBuilder arguments() {
        return new ActionParameterListBuilder();
    }

    public <T> ResponseDigest<T> digest(Response response, Class<T> entityType) {
        return ResponseDigest.of(response, entityType);
    }

    public <T> CompletableFuture<ResponseDigest<T>> digest(Future<Response> asyncResponse, Class<T> entityType) {
        CompletableFuture<ResponseDigest<T>> completableFuture = CompletableFuture.supplyAsync(() -> {
            try {
                Response response = (Response)asyncResponse.get();
                ResponseDigest digest = this.digest(response, entityType);
                return digest;
            }
            catch (Exception e) {
                return ResponseDigest.ofAsyncFailure(asyncResponse, entityType, e);
            }
        });
        return completableFuture;
    }

    private void registerDefaultJsonProvider() {
        try {
            Class MOXyJsonProvider = _Context.loadClass((String)"org.eclipse.persistence.jaxb.rs.MOXyJsonProvider");
            this.client.register(MOXyJsonProvider);
        }
        catch (Exception e) {
            LOG.warning("This implementation of RestfulClient does require the class 'MOXyJsonProvider' on the class-path. Are you missing a maven dependency?");
        }
    }

    private void registerBasicAuthFilter() {
        if (this.clientConfig.isUseBasicAuth()) {
            BasicAuthFilter.Credentials credentials = BasicAuthFilter.Credentials.of(this.clientConfig.getRestfulAuthUser(), this.clientConfig.getRestfulAuthPassword());
            this.client.register((Object)BasicAuthFilter.of(credentials));
        }
    }

    private void registerRequestDebugLoggingFilter() {
        if (this.clientConfig.isUseRequestDebugLogging()) {
            this.client.register((Object)new RestfulLoggingFilter());
        }
    }

    private String relativePathToUri(String path) {
        String baseUri = _Strings.suffix((String)this.clientConfig.getRestfulBase(), (String)"/");
        while (path.startsWith("/")) {
            path = path.substring(1);
        }
        return baseUri + path;
    }

    private String toSuppressionLiteral(EnumSet<SuppressionType> suppressionTypes) {
        String suppressionSetLiteral = _NullSafe.stream(suppressionTypes).map(Enum::name).collect(Collectors.joining(","));
        if (_Strings.isNotEmpty((CharSequence)suppressionSetLiteral)) {
            return ";suppress=" + suppressionSetLiteral;
        }
        return "";
    }
}

