/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.applib.client;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.Collectors;
import javax.ws.rs.client.Entity;

public class ActionParameterListBuilder {
    private final Map<String, String> actionParameters = new LinkedHashMap<String, String>();
    private static final String JSON_NULL_LITERAL = "null";

    public ActionParameterListBuilder addActionParameter(String parameterName, String parameterValue) {
        this.actionParameters.put(parameterName, parameterValue != null ? this.value("\"" + parameterValue + "\"") : this.value(JSON_NULL_LITERAL));
        return this;
    }

    public ActionParameterListBuilder addActionParameter(String parameterName, int parameterValue) {
        this.actionParameters.put(parameterName, this.value("" + parameterValue));
        return this;
    }

    public ActionParameterListBuilder addActionParameter(String parameterName, long parameterValue) {
        this.actionParameters.put(parameterName, this.value("" + parameterValue));
        return this;
    }

    public ActionParameterListBuilder addActionParameter(String parameterName, byte parameterValue) {
        this.actionParameters.put(parameterName, this.value("" + parameterValue));
        return this;
    }

    public ActionParameterListBuilder addActionParameter(String parameterName, short parameterValue) {
        this.actionParameters.put(parameterName, this.value("" + parameterValue));
        return this;
    }

    public ActionParameterListBuilder addActionParameter(String parameterName, double parameterValue) {
        this.actionParameters.put(parameterName, this.value("" + parameterValue));
        return this;
    }

    public ActionParameterListBuilder addActionParameter(String parameterName, float parameterValue) {
        this.actionParameters.put(parameterName, this.value("" + parameterValue));
        return this;
    }

    public ActionParameterListBuilder addActionParameter(String parameterName, boolean parameterValue) {
        this.actionParameters.put(parameterName, this.value("" + parameterValue));
        return this;
    }

    public Entity<String> build() {
        StringBuilder sb = new StringBuilder();
        sb.append("{\n").append(this.actionParameters.entrySet().stream().map(this::toJson).collect(Collectors.joining(",\n"))).append("\n}");
        return Entity.json((Object)sb.toString());
    }

    private String value(String valueLiteral) {
        return "{\"value\" : " + valueLiteral + "}";
    }

    private String toJson(Map.Entry<String, String> entry) {
        return "   \"" + entry.getKey() + "\": " + entry.getValue();
    }
}

