/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.applib;

import org.apache.isis.applib.services.exceprecog.TranslatableException;
import org.apache.isis.applib.services.i18n.TranslatableString;
import org.apache.isis.commons.internal.base._Strings;
import org.apache.isis.commons.internal.exceptions._Exceptions;

public class RecoverableException
extends RuntimeException
implements TranslatableException {
    private static final long serialVersionUID = 1L;
    private final TranslatableString translatableMessage;
    private final String translationContext;

    public RecoverableException(String msg) {
        this(msg, null, null, null, null);
    }

    public RecoverableException(TranslatableString translatableMessage, Class<?> translationContextClass, String translationContextMethod) {
        this(null, translatableMessage, translationContextClass, translationContextMethod, null);
    }

    public RecoverableException(Throwable cause) {
        this(null, null, null, null, cause);
    }

    public RecoverableException(String msg, Throwable cause) {
        this(msg, null, null, null, cause);
    }

    public RecoverableException(TranslatableString translatableMessage, Class<?> translationContextClass, String translationContextMethod, Throwable cause) {
        this(null, translatableMessage, translationContextClass, translationContextMethod, cause);
    }

    private RecoverableException(String message, TranslatableString translatableMessage, Class<?> translationContextClass, String translationContextMethod, Throwable cause) {
        super(message, cause);
        this.translatableMessage = translatableMessage;
        this.translationContext = translationContextClass != null ? translationContextClass.getName() + (!_Strings.isNullOrEmpty((CharSequence)translationContextMethod) ? "#" + translationContextMethod : "") : null;
    }

    @Override
    public String getMessage() {
        return this.getTranslatableMessage() != null ? this.getTranslatableMessage().getPattern() : super.getMessage();
    }

    @Override
    public TranslatableString getTranslatableMessage() {
        return this.translatableMessage;
    }

    @Override
    public String getTranslationContext() {
        return this.translationContext;
    }

    public static class Util {
        private Util() {
        }

        public static RecoverableException getRecoverableExceptionIfAny(Exception ex) {
            return _Exceptions.streamCausalChain((Throwable)ex).filter(t -> t instanceof RecoverableException).map(t -> (RecoverableException)t).findFirst().orElse(null);
        }
    }
}

