/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.applib;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.apache.isis.applib.fixturescripts.FixtureScript;

public interface AppManifest {
    public static final AppManifest NOOP = new AppManifest(){

        @Override
        public List<Class<?>> getModules() {
            return null;
        }

        @Override
        public List<Class<?>> getAdditionalServices() {
            return null;
        }

        @Override
        public String getAuthenticationMechanism() {
            return null;
        }

        @Override
        public String getAuthorizationMechanism() {
            return null;
        }

        @Override
        public List<Class<? extends FixtureScript>> getFixtures() {
            return null;
        }

        @Override
        public Map<String, String> getConfigurationProperties() {
            return null;
        }
    };

    public List<Class<?>> getModules();

    public List<Class<?>> getAdditionalServices();

    public String getAuthenticationMechanism();

    public String getAuthorizationMechanism();

    public List<Class<? extends FixtureScript>> getFixtures();

    public Map<String, String> getConfigurationProperties();

    public static AppManifest noop() {
        return NOOP;
    }

    public static class Util {
        public static final String ISIS_PERSISTOR = "isis.persistor.";
        public static final String ISIS_PERSISTOR_DATANUCLEUS = "isis.persistor.datanucleus.";
        public static final String ISIS_PERSISTOR_DATANUCLEUS_IMPL = "isis.persistor.datanucleus.impl.";

        public static Map<String, String> withH2InMemoryProperties(Map<String, String> map) {
            map.put("isis.persistor.datanucleus.impl.javax.jdo.option.ConnectionURL", "jdbc:h2:mem:test-" + UUID.randomUUID().toString());
            map.put("isis.persistor.datanucleus.impl.javax.jdo.option.ConnectionDriverName", "org.h2.Driver");
            map.put("isis.persistor.datanucleus.impl.javax.jdo.option.ConnectionUserName", "sa");
            map.put("isis.persistor.datanucleus.impl.javax.jdo.option.ConnectionPassword", "");
            return map;
        }

        public static Map<String, String> withHsqlDbInMemoryProperties(Map<String, String> map) {
            map.put("isis.persistor.datanucleus.impl.javax.jdo.option.ConnectionURL", "jdbc:hsqldb:mem:test-" + UUID.randomUUID().toString());
            map.put("isis.persistor.datanucleus.impl.javax.jdo.option.ConnectionDriverName", "org.hsqldb.jdbcDriver");
            map.put("isis.persistor.datanucleus.impl.javax.jdo.option.ConnectionUserName", "sa");
            map.put("isis.persistor.datanucleus.impl.javax.jdo.option.ConnectionPassword", "");
            return map;
        }

        @Deprecated
        public static Map<String, String> withJavaxJdoRunInMemoryProperties(Map<String, String> map) {
            return Util.withHsqlDbInMemoryProperties(map);
        }

        public static Map<String, String> withDataNucleusProperties(Map<String, String> map) {
            map.put("isis.persistor.datanucleus.impl.datanucleus.schema.autoCreateAll", "true");
            map.put("isis.persistor.datanucleus.impl.datanucleus.schema.validateAll", "false");
            map.put("isis.persistor.datanucleus.impl.datanucleus.persistenceByReachabilityAtCommit", "false");
            map.put("isis.persistor.datanucleus.impl.datanucleus.identifier.case", "MixedCase");
            map.put("isis.persistor.datanucleus.impl.datanucleus.cache.level2.type", "none");
            map.put("isis.persistor.datanucleus.impl.datanucleus.cache.level2.mode", "ENABLE_SELECTIVE");
            return map;
        }

        public static Map<String, String> withIsisIntegTestProperties(Map<String, String> map) {
            map.put("isis.persistor.datanucleus.install-fixtures", "true");
            map.put("isis.persistor.enforceSafeSemantics", "false");
            map.put("isis.services.eventbus.allowLateRegistration", "true");
            return map;
        }

        public static enum MemDb {
            HSQLDB{

                @Override
                public void withProperties(Map<String, String> map) {
                    Util.withHsqlDbInMemoryProperties(map);
                }
            }
            ,
            H2{

                @Override
                public void withProperties(Map<String, String> map) {
                    Util.withH2InMemoryProperties(map);
                }
            };


            public abstract void withProperties(Map<String, String> var1);
        }
    }

    public static final class Registry {
        public static final List<String> FRAMEWORK_PROVIDED_SERVICE_PACKAGES = Collections.unmodifiableList(Arrays.asList("org.apache.isis.applib", "org.apache.isis.core.wrapper", "org.apache.isis.core.metamodel.services", "org.apache.isis.core.runtime.services", "org.apache.isis.schema.services", "org.apache.isis.objectstore.jdo.applib.service", "org.apache.isis.viewer.restfulobjects.rendering.service", "org.apache.isis.objectstore.jdo.datanucleus.service.support", "org.apache.isis.objectstore.jdo.datanucleus.service.eventbus", "org.apache.isis.viewer.wicket.viewer.services", "org.apache.isis.core.integtestsupport.components"));
        private static Registry instance = new Registry();
        private Set<Class<?>> persistenceCapableTypes;
        private Set<Class<?>> mixinTypes;
        private Set<Class<? extends FixtureScript>> fixtureScriptTypes;
        private Set<Class<?>> domainServiceTypes;
        private Set<Class<?>> domainObjectTypes;
        private Set<Class<?>> viewModelTypes;
        private Set<Class<?>> xmlElementTypes;

        public static Registry instance() {
            return instance;
        }

        public Set<Class<?>> getPersistenceCapableTypes() {
            return this.persistenceCapableTypes;
        }

        public void setPersistenceCapableTypes(Set<Class<?>> persistenceCapableTypes) {
            this.persistenceCapableTypes = persistenceCapableTypes;
        }

        public Set<Class<?>> getMixinTypes() {
            return this.mixinTypes;
        }

        public void setMixinTypes(Set<Class<?>> mixinTypes) {
            this.mixinTypes = mixinTypes;
        }

        public Set<Class<? extends FixtureScript>> getFixtureScriptTypes() {
            return this.fixtureScriptTypes;
        }

        public void setFixtureScriptTypes(Set<Class<? extends FixtureScript>> fixtureScriptTypes) {
            this.fixtureScriptTypes = fixtureScriptTypes;
        }

        public Set<Class<?>> getDomainServiceTypes() {
            return this.domainServiceTypes;
        }

        public void setDomainServiceTypes(Set<Class<?>> domainServiceTypes) {
            this.domainServiceTypes = domainServiceTypes;
        }

        public Set<Class<?>> getDomainObjectTypes() {
            return this.domainObjectTypes;
        }

        public void setDomainObjectTypes(Set<Class<?>> domainObjectTypes) {
            this.domainObjectTypes = domainObjectTypes;
        }

        public Set<Class<?>> getViewModelTypes() {
            return this.viewModelTypes;
        }

        public void setViewModelTypes(Set<Class<?>> viewModelTypes) {
            this.viewModelTypes = viewModelTypes;
        }

        public Set<Class<?>> getXmlElementTypes() {
            return this.xmlElementTypes;
        }

        public void setXmlElementTypes(Set<Class<?>> xmlElementTypes) {
            this.xmlElementTypes = xmlElementTypes;
        }
    }
}

