/*
 * Decompiled with CFR 0.152.
 */
package de.agilecoders.wicket.core.markup.html.bootstrap.form;

import java.util.ArrayList;
import java.util.List;
import org.apache.wicket.markup.html.form.AbstractChoice;
import org.apache.wicket.markup.html.form.ChoiceRenderer;
import org.apache.wicket.markup.html.form.IChoiceRenderer;
import org.apache.wicket.markup.html.form.RadioChoice;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.util.ListModel;
import org.apache.wicket.util.value.IValueMap;
import org.apache.wicket.util.value.ValueMap;

public class BootstrapRadioChoice<T>
extends RadioChoice<T> {
    private boolean inline = false;

    public BootstrapRadioChoice(String id) {
        this(id, new ArrayList());
    }

    public BootstrapRadioChoice(String id, List<T> choices) {
        this(id, choices, (IChoiceRenderer<T>)new ChoiceRenderer());
    }

    public BootstrapRadioChoice(String id, List<T> choices, IChoiceRenderer<? super T> renderer) {
        this(id, null, choices, renderer);
    }

    public BootstrapRadioChoice(String id, IModel<T> model, List<T> choices) {
        this(id, model, choices, (IChoiceRenderer<T>)new ChoiceRenderer());
    }

    public BootstrapRadioChoice(String id, IModel<T> model, List<T> choices, IChoiceRenderer<? super T> renderer) {
        this(id, (IModel<? super T>)model, (IModel<List<? super T>>)new ListModel(choices), renderer);
    }

    public BootstrapRadioChoice(String id, IModel<? extends List<? extends T>> choices) {
        this(id, (IModel<List<T>>)choices, (IChoiceRenderer<T>)new ChoiceRenderer());
    }

    public BootstrapRadioChoice(String id, IModel<T> model, IModel<? extends List<? extends T>> choices) {
        this(id, model, (IModel<List<T>>)choices, (IChoiceRenderer<T>)new ChoiceRenderer());
    }

    public BootstrapRadioChoice(String id, IModel<? extends List<? extends T>> choices, IChoiceRenderer<? super T> renderer) {
        this(id, null, choices, renderer);
    }

    public BootstrapRadioChoice(String id, IModel<T> model, IModel<? extends List<? extends T>> choices, IChoiceRenderer<? super T> renderer) {
        super(id, model, choices, renderer);
        this.setInline(false);
        this.setLabelPosition(AbstractChoice.LabelPosition.WRAP_AFTER);
    }

    public boolean isInline() {
        return this.inline;
    }

    public BootstrapRadioChoice<T> setInline(boolean inline) {
        if (inline) {
            this.setPrefix("");
            this.setSuffix("");
        } else {
            this.setPrefix("<div class=\"radio\">");
            this.setSuffix("</div>");
        }
        this.inline = inline;
        return this;
    }

    protected IValueMap getAdditionalAttributesForLabel(int index, T choice) {
        ValueMap attrs = null;
        if (this.isInline()) {
            attrs = new ValueMap();
            attrs.put((Object)"class", (Object)"radio-inline");
        }
        return attrs;
    }
}

