/*
 * Decompiled with CFR 0.152.
 */
package de.agilecoders.wicket.core.markup.html.bootstrap.carousel;

import de.agilecoders.wicket.core.markup.html.bootstrap.behavior.BootstrapResourcesBehavior;
import de.agilecoders.wicket.core.markup.html.bootstrap.behavior.CssClassNameAppender;
import de.agilecoders.wicket.core.markup.html.bootstrap.carousel.ICarouselImage;
import de.agilecoders.wicket.core.util.Attributes;
import de.agilecoders.wicket.jquery.util.Strings2;
import java.io.Serializable;
import java.util.List;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.head.OnDomReadyHeaderItem;
import org.apache.wicket.markup.html.TransparentWebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.util.time.Duration;

public class Carousel
extends Panel {
    private Duration interval = Duration.seconds((int)5);
    private final IModel<List<ICarouselImage>> model;

    public Carousel(String markupId, List<ICarouselImage> images) {
        this(markupId, (IModel<List<ICarouselImage>>)Model.ofList(images));
    }

    public Carousel(String markupId, IModel<List<ICarouselImage>> model) {
        super(markupId, model);
        this.model = model;
        this.setOutputMarkupId(true);
        BootstrapResourcesBehavior.addTo((Component)this);
        this.add(new Component[]{this.newImageList("images"), this.newNavigationButton("prev"), this.newNavigationButton("next")});
    }

    protected void onComponentTag(ComponentTag tag) {
        super.onComponentTag(tag);
        this.checkComponentTag(tag, "div");
        Attributes.addClass(tag, "carousel", "slide");
    }

    private Component newNavigationButton(String markupId) {
        Label button = new Label(markupId);
        button.add(new Behavior[]{new AttributeModifier("href", (Serializable)((Object)("#" + this.getMarkupId(true))))});
        button.setEscapeModelStrings(false);
        if ("prev".equals(markupId)) {
            button.setDefaultModel(this.createPrevLabel());
        } else {
            button.setDefaultModel(this.createNextLabel());
        }
        return button;
    }

    protected IModel<String> createPrevLabel() {
        return Model.of((Serializable)((Object)"&lsaquo;"));
    }

    protected IModel<String> createNextLabel() {
        return Model.of((Serializable)((Object)"&rsaquo;"));
    }

    protected Component newImageList(String wicketId) {
        return new ListView<ICarouselImage>(wicketId, this.model){

            protected void populateItem(ListItem<ICarouselImage> item) {
                ICarouselImage carouselImage = (ICarouselImage)item.getModelObject();
                Component image = Carousel.this.newImage("image", carouselImage);
                Component header = Carousel.this.newHeader("header", carouselImage);
                Component description = Carousel.this.newDescription("description", carouselImage);
                TransparentWebMarkupContainer caption = new TransparentWebMarkupContainer("caption");
                caption.setVisible(header.isVisible() || description.isVisible());
                if (item.getIndex() == 0) {
                    item.add(new Behavior[]{new CssClassNameAppender("active")});
                }
                item.add(new Component[]{image, header, description, caption});
            }
        };
    }

    protected Component newImage(String markupId, ICarouselImage image) {
        Label img = new Label(markupId);
        img.add(new Behavior[]{new AttributeModifier("src", (Serializable)((Object)image.url()))});
        return img;
    }

    protected Component newDescription(String markupId, ICarouselImage image) {
        Label description = new Label(markupId);
        if (image.description() != null) {
            description.setDefaultModel((IModel)Model.of((Serializable)((Object)image.description())));
        } else {
            description.setVisible(false);
        }
        return description;
    }

    protected Component newHeader(String markupId, ICarouselImage image) {
        Label header = new Label(markupId);
        if (image.header() != null) {
            header.setDefaultModel((IModel)Model.of((Serializable)((Object)image.header())));
        } else {
            header.setVisible(false);
        }
        return header;
    }

    public void renderHead(IHeaderResponse response) {
        super.renderHead(response);
        response.render((HeaderItem)OnDomReadyHeaderItem.forScript((CharSequence)("$('#" + Strings2.getMarkupId((Component)this) + "').carousel({\n" + "  interval: " + this.getInterval().getMilliseconds() + "\n" + "})")));
    }

    public final Duration getInterval() {
        return this.interval;
    }

    public final Carousel setInterval(Duration interval) {
        this.interval = interval;
        return this;
    }
}

