/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.types.jodatime.converters;

import org.datanucleus.store.types.converters.ColumnLengthDefiningTypeConverter;
import org.datanucleus.store.types.converters.TypeConverter;
import org.joda.time.LocalTime;
import org.joda.time.format.ISODateTimeFormat;

public class JodaLocalTimeStringConverter
implements TypeConverter<LocalTime, String>,
ColumnLengthDefiningTypeConverter {
    private static final long serialVersionUID = 6490626063186033515L;

    public String toDatastoreType(LocalTime lt) {
        return lt != null ? lt.toString("HH:mm:ss.SSS") : null;
    }

    public LocalTime toMemberType(String str) {
        if (str == null) {
            return null;
        }
        return ISODateTimeFormat.hourMinuteSecondMillis().parseDateTime(str).toLocalTime();
    }

    public int getDefaultColumnLength(int columnPosition) {
        if (columnPosition != 0) {
            return -1;
        }
        return 12;
    }
}

