/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.model.models;

import java.io.Serializable;
import org.apache.isis.core.metamodel.adapter.mgr.AdapterManager;
import org.apache.isis.viewer.wicket.model.mementos.ObjectAdapterMemento;
import org.apache.isis.viewer.wicket.model.models.ScalarModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface ScalarModelWithPending
extends Serializable {
    public ObjectAdapterMemento getPending();

    public void setPending(ObjectAdapterMemento var1);

    public ScalarModel getScalarModel();

    public static class Util {
        private static final Logger LOG = LoggerFactory.getLogger(Util.class);

        public static IModel<ObjectAdapterMemento> createModel(ScalarModel model) {
            return Util.createModel(model.asScalarModelWithPending());
        }

        public static Model<ObjectAdapterMemento> createModel(final ScalarModelWithPending owner) {
            return new Model<ObjectAdapterMemento>(){
                private static final long serialVersionUID = 1L;

                public ObjectAdapterMemento getObject() {
                    if (owner.getPending() != null) {
                        LOG.debug("pending not null: {}", (Object)owner.getPending().toString());
                        return owner.getPending();
                    }
                    LOG.debug("pending is null");
                    ObjectAdapterMemento objectAdapterMemento = owner.getScalarModel().getObjectAdapterMemento();
                    owner.setPending(objectAdapterMemento);
                    return objectAdapterMemento;
                }

                public void setObject(ObjectAdapterMemento adapterMemento) {
                    LOG.debug("setting to: {}", (Object)(adapterMemento != null ? adapterMemento.toString() : null));
                    owner.setPending(adapterMemento);
                    ScalarModel ownerScalarModel = owner.getScalarModel();
                    if (ownerScalarModel != null) {
                        if (adapterMemento == null) {
                            ownerScalarModel.setObject(null);
                        } else {
                            ObjectAdapterMemento ownerPending = owner.getPending();
                            if (ownerPending != null) {
                                LOG.debug("setting to pending: {}", (Object)ownerPending.toString());
                                ownerScalarModel.setObject(ownerPending.getObjectAdapter(AdapterManager.ConcurrencyChecking.NO_CHECK, ownerScalarModel.getPersistenceSession(), ownerScalarModel.getSpecificationLoader()));
                            }
                        }
                    }
                }
            };
        }
    }
}

