/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.model.models;

import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Set;
import org.apache.isis.applib.services.bookmark.Bookmark;
import org.apache.isis.applib.services.hint.HintStore;
import org.apache.isis.core.runtime.system.context.IsisContext;
import org.apache.isis.core.runtime.system.session.IsisSessionFactory;
import org.apache.isis.viewer.wicket.model.mementos.ObjectAdapterMemento;
import org.apache.isis.viewer.wicket.model.models.EntityModel;
import org.apache.isis.viewer.wicket.model.util.ComponentHintKey;
import org.apache.wicket.request.mapper.parameter.PageParameters;

class HintPageParameterSerializer
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final String PREFIX = "hint-";

    private HintPageParameterSerializer() {
    }

    public static void hintStoreToPageParameters(PageParameters pageParameters, EntityModel entityModel) {
        ObjectAdapterMemento objectAdapterMemento = entityModel.getObjectAdapterMemento();
        HintPageParameterSerializer.hintStoreToPageParameters(pageParameters, objectAdapterMemento);
    }

    public static void hintStoreToPageParameters(PageParameters pageParameters, ObjectAdapterMemento objectAdapterMemento) {
        if (objectAdapterMemento == null) {
            return;
        }
        HintStore hintStore = HintPageParameterSerializer.getHintStore();
        Bookmark bookmark = objectAdapterMemento.asHintingBookmark();
        Set hintKeys = hintStore.findHintKeys(bookmark);
        for (String hintKey : hintKeys) {
            ComponentHintKey.create(hintKey).hintTo(bookmark, pageParameters, PREFIX);
        }
    }

    public static void updateHintStoreUNUSED(PageParameters pageParameters, ObjectAdapterMemento objectAdapterMemento) {
        if (objectAdapterMemento == null) {
            return;
        }
        Set namedKeys = pageParameters.getNamedKeys();
        if (namedKeys.contains("no-hints")) {
            HintPageParameterSerializer.getHintStore().removeAll(objectAdapterMemento.asHintingBookmark());
            return;
        }
        ArrayList newComponentHintKeys = Lists.newArrayList();
        for (String namedKey : namedKeys) {
            if (!namedKey.startsWith(PREFIX)) continue;
            String value = pageParameters.get(namedKey).toString(null);
            String key = namedKey.substring(5);
            ComponentHintKey componentHintKey = ComponentHintKey.create(key);
            newComponentHintKeys.add(componentHintKey);
            Bookmark bookmark = objectAdapterMemento.asHintingBookmark();
            componentHintKey.set(bookmark, value);
        }
    }

    private static HintStore getHintStore() {
        return (HintStore)HintPageParameterSerializer.getIsisSessionFactory().getServicesInjector().lookupService(HintStore.class);
    }

    private static IsisSessionFactory getIsisSessionFactory() {
        return IsisContext.getSessionFactory();
    }
}

