/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.model.models;

import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.viewer.wicket.model.mementos.ObjectAdapterMemento;
import org.apache.isis.viewer.wicket.model.models.EntityModel;
import org.apache.isis.viewer.wicket.model.models.HintPageParameterSerializer;
import org.apache.isis.viewer.wicket.model.models.ObjectAdapterModel;
import org.apache.isis.viewer.wicket.model.models.ScalarModel;
import org.apache.wicket.request.mapper.parameter.PageParameters;

public class EntityModelForReference
implements ObjectAdapterModel {
    private static final long serialVersionUID = 1L;
    private final ScalarModel scalarModel;
    private ObjectAdapterMemento contextAdapterIfAny;
    private EntityModel.RenderingHint renderingHint;

    public EntityModelForReference(ScalarModel scalarModel) {
        this.scalarModel = scalarModel;
    }

    public ObjectAdapter getObject() {
        return this.scalarModel.getPendingElseCurrentAdapter();
    }

    public void setObject(ObjectAdapter adapter) {
    }

    public void detach() {
    }

    @Override
    public ObjectAdapterMemento getContextAdapterIfAny() {
        return this.contextAdapterIfAny;
    }

    @Override
    public void setContextAdapterIfAny(ObjectAdapterMemento contextAdapterIfAny) {
        this.contextAdapterIfAny = contextAdapterIfAny;
    }

    @Override
    public EntityModel.RenderingHint getRenderingHint() {
        return this.renderingHint;
    }

    @Override
    public void setRenderingHint(EntityModel.RenderingHint renderingHint) {
        this.renderingHint = renderingHint;
    }

    @Override
    public PageParameters getPageParametersWithoutUiHints() {
        return EntityModel.createPageParameters(this.getObject());
    }

    @Override
    public ObjectSpecification getTypeOfSpecification() {
        return this.scalarModel.getTypeOfSpecification();
    }

    @Override
    public EntityModel.Mode getMode() {
        return EntityModel.Mode.VIEW;
    }

    @Override
    public PageParameters getPageParameters() {
        PageParameters pageParameters = EntityModel.createPageParameters(this.getObject());
        ObjectAdapterMemento oam = ObjectAdapterMemento.createOrNull(this.getObject());
        HintPageParameterSerializer.hintStoreToPageParameters(pageParameters, oam);
        return pageParameters;
    }

    @Override
    public boolean isInlinePrompt() {
        return this.scalarModel.getPromptStyle().isInlineOrInlineAsIfEdit() && this.scalarModel.isEnabled();
    }
}

