/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.model.models;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.apache.isis.applib.layout.component.CollectionLayoutData;
import org.apache.isis.core.commons.factory.InstanceUtil;
import org.apache.isis.core.commons.lang.ClassUtil;
import org.apache.isis.core.commons.lang.Closure;
import org.apache.isis.core.commons.lang.IterableExtensions;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.adapter.mgr.AdapterManager;
import org.apache.isis.core.metamodel.consent.InteractionInitiatedBy;
import org.apache.isis.core.metamodel.facets.collections.sortedby.SortedByFacet;
import org.apache.isis.core.metamodel.facets.object.paged.PagedFacet;
import org.apache.isis.core.metamodel.facets.object.plural.PluralFacet;
import org.apache.isis.core.metamodel.spec.ObjectSpecId;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.core.metamodel.spec.feature.OneToManyAssociation;
import org.apache.isis.core.runtime.system.persistence.PersistenceSession;
import org.apache.isis.core.runtime.system.session.IsisSessionFactory;
import org.apache.isis.viewer.wicket.model.hints.UiHintContainer;
import org.apache.isis.viewer.wicket.model.links.LinkAndLabel;
import org.apache.isis.viewer.wicket.model.links.LinksProvider;
import org.apache.isis.viewer.wicket.model.mementos.CollectionMemento;
import org.apache.isis.viewer.wicket.model.mementos.ObjectAdapterMemento;
import org.apache.isis.viewer.wicket.model.models.ActionModel;
import org.apache.isis.viewer.wicket.model.models.EntityModel;
import org.apache.isis.viewer.wicket.model.models.ModelAbstract;
import org.apache.wicket.Component;

public class EntityCollectionModel
extends ModelAbstract<List<ObjectAdapter>>
implements LinksProvider,
UiHintContainer {
    private static final long serialVersionUID = 1L;
    private static final String KEY_BULK_LOAD = "isis.persistor.datanucleus.standaloneCollection.bulkLoad";
    private static final int PAGE_SIZE_DEFAULT_FOR_PARENTED = 12;
    private static final int PAGE_SIZE_DEFAULT_FOR_STANDALONE = 25;
    private final Type type;
    private final Class<?> typeOf;
    private transient ObjectSpecification typeOfSpec;
    private List<ObjectAdapterMemento> mementoList;
    private List<ObjectAdapterMemento> toggledMementosList;
    private final EntityModel entityModel;
    private CollectionMemento collectionMemento;
    private final int pageSize;
    private List<LinkAndLabel> linkAndLabels = Lists.newArrayList();
    private Class<? extends Comparator<?>> sortedBy;
    private ActionModel actionModelHint;
    public static final String HINT_KEY_SELECTED_ITEM = "selectedItem";

    public static EntityCollectionModel createStandalone(ObjectAdapter collectionAsAdapter, IsisSessionFactory sessionFactory) {
        Class elementType;
        ObjectSpecification elementSpec;
        Iterable<Object> pojos = EntityCollectionModel.asIterable(collectionAsAdapter);
        ArrayList mementoList = Lists.newArrayList((Iterable)Iterables.transform(pojos, ObjectAdapterMemento.Functions.fromPojo((AdapterManager)sessionFactory.getCurrentSession().getPersistenceSession())));
        if (!Iterables.isEmpty(pojos)) {
            LowestCommonSuperclassClosure closure = new LowestCommonSuperclassClosure();
            Function function = new Function<Object, Class<?>>(){

                public Class<?> apply(Object obj) {
                    return obj.getClass();
                }
            };
            IterableExtensions.fold((Iterable)Iterables.transform(pojos, (Function)function), (Closure)closure);
            elementSpec = sessionFactory.getSpecificationLoader().loadSpecification(closure.getLowestCommonSuperclass());
        } else {
            elementSpec = collectionAsAdapter.getElementSpecification();
        }
        int pageSize = 25;
        if (elementSpec != null) {
            elementType = elementSpec.getCorrespondingClass();
            pageSize = EntityCollectionModel.pageSize((PagedFacet)elementSpec.getFacet(PagedFacet.class), 25);
        } else {
            elementType = Object.class;
        }
        return new EntityCollectionModel(elementType, mementoList, pageSize);
    }

    public ActionModel getActionModelHint() {
        return this.actionModelHint;
    }

    public void setActionHint(ActionModel actionModelHint) {
        this.actionModelHint = actionModelHint;
    }

    public static EntityCollectionModel createParented(EntityModel modelWithCollectionLayoutMetadata) {
        return new EntityCollectionModel(modelWithCollectionLayoutMetadata);
    }

    public Type getType() {
        return this.type;
    }

    private EntityCollectionModel(Class<?> typeOf, List<ObjectAdapterMemento> mementoList, int pageSize) {
        this.type = Type.STANDALONE;
        this.entityModel = null;
        this.typeOf = typeOf;
        this.mementoList = mementoList;
        this.pageSize = pageSize;
        this.toggledMementosList = Lists.newArrayList();
    }

    private EntityCollectionModel(EntityModel entityModel) {
        this.type = Type.PARENTED;
        this.entityModel = entityModel;
        OneToManyAssociation collection = this.collectionFor(entityModel.getObjectAdapterMemento(), this.getLayoutData());
        this.typeOf = EntityCollectionModel.forName(collection.getSpecification());
        this.collectionMemento = new CollectionMemento(collection, entityModel.getIsisSessionFactory());
        this.pageSize = EntityCollectionModel.pageSize((PagedFacet)collection.getFacet(PagedFacet.class), 12);
        SortedByFacet sortedByFacet = (SortedByFacet)collection.getFacet(SortedByFacet.class);
        this.sortedBy = sortedByFacet != null ? (Class)sortedByFacet.value() : null;
        this.toggledMementosList = Lists.newArrayList();
    }

    private OneToManyAssociation collectionFor(ObjectAdapterMemento parentObjectAdapterMemento, CollectionLayoutData collectionLayoutData) {
        if (collectionLayoutData == null) {
            throw new IllegalArgumentException("EntityModel must have a CollectionLayoutMetadata");
        }
        String collectionId = collectionLayoutData.getId();
        ObjectSpecId objectSpecId = parentObjectAdapterMemento.getObjectSpecId();
        ObjectSpecification objectSpec = this.getIsisSessionFactory().getSpecificationLoader().lookupBySpecId(objectSpecId);
        OneToManyAssociation otma = (OneToManyAssociation)objectSpec.getAssociation(collectionId);
        return otma;
    }

    private static Class<?> forName(ObjectSpecification objectSpec) {
        String fullName = objectSpec.getFullIdentifier();
        return ClassUtil.forName((String)fullName);
    }

    private static int pageSize(PagedFacet pagedFacet, int defaultPageSize) {
        return pagedFacet != null ? pagedFacet.value() : defaultPageSize;
    }

    public boolean isParented() {
        return this.type == Type.PARENTED;
    }

    public boolean isStandalone() {
        return this.type == Type.STANDALONE;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public String getName() {
        return this.type.getName(this);
    }

    public int getCount() {
        return this.type.getCount(this);
    }

    public CollectionLayoutData getLayoutData() {
        return this.entityModel != null ? this.entityModel.getCollectionLayoutData() : null;
    }

    protected List<ObjectAdapter> load() {
        return this.type.load(this);
    }

    public ObjectSpecification getTypeOfSpecification() {
        if (this.typeOfSpec == null) {
            this.typeOfSpec = this.getSpecificationLoader().loadSpecification(this.typeOf);
        }
        return this.typeOfSpec;
    }

    public void setObject(List<ObjectAdapter> list) {
        super.setObject(list);
        this.type.setObject(this, list);
    }

    public void setObjectList(ObjectAdapter resultAdapter) {
        Iterable<Object> pojos = EntityCollectionModel.asIterable(resultAdapter);
        this.mementoList = Lists.newArrayList((Iterable)Iterables.transform(pojos, ObjectAdapterMemento.Functions.fromPojo((AdapterManager)this.getPersistenceSession())));
    }

    public EntityModel getEntityModel() {
        return this.entityModel;
    }

    public ObjectAdapterMemento getParentObjectAdapterMemento() {
        return this.entityModel != null ? this.entityModel.getObjectAdapterMemento() : null;
    }

    public CollectionMemento getCollectionMemento() {
        return this.collectionMemento;
    }

    private static Iterable<Object> asIterable(ObjectAdapter resultAdapter) {
        return (Iterable)resultAdapter.getObject();
    }

    public void toggleSelectionOn(ObjectAdapter selectedAdapter) {
        ObjectAdapterMemento selectedAsMemento = ObjectAdapterMemento.createOrNull(selectedAdapter);
        boolean removed = this.toggledMementosList.remove(selectedAsMemento);
        if (!removed) {
            this.toggledMementosList.add(selectedAsMemento);
        }
    }

    public List<ObjectAdapterMemento> getToggleMementosList() {
        return Collections.unmodifiableList(Lists.newArrayList(this.toggledMementosList));
    }

    public void clearToggleMementosList() {
        this.toggledMementosList.clear();
    }

    public void addLinkAndLabels(List<LinkAndLabel> linkAndLabels) {
        this.linkAndLabels.clear();
        this.linkAndLabels.addAll(linkAndLabels);
    }

    @Override
    public List<LinkAndLabel> getLinks() {
        return Collections.unmodifiableList(this.linkAndLabels);
    }

    public EntityCollectionModel asDummy() {
        return new EntityCollectionModel(this.typeOf, Collections.emptyList(), this.pageSize);
    }

    @Override
    public String getHint(Component component, String attributeName) {
        if (this.getEntityModel() == null) {
            return null;
        }
        return this.getEntityModel().getHint(component, attributeName);
    }

    @Override
    public void setHint(Component component, String attributeName, String attributeValue) {
        if (this.getEntityModel() == null) {
            return;
        }
        this.getEntityModel().setHint(component, attributeName, attributeValue);
    }

    @Override
    public void clearHint(Component component, String attributeName) {
        if (this.getEntityModel() == null) {
            return;
        }
        this.getEntityModel().clearHint(component, attributeName);
    }

    static class LowestCommonSuperclassClosure
    implements Closure<Class<?>> {
        private Class<?> common;

        LowestCommonSuperclassClosure() {
        }

        public Class<?> execute(Class<?> value) {
            if (this.common == null) {
                this.common = value;
            } else {
                Class<?> current = this.common;
                while (!current.isAssignableFrom(value)) {
                    current = current.getSuperclass();
                }
                this.common = current;
            }
            return this.common;
        }

        Class<?> getLowestCommonSuperclass() {
            return this.common;
        }
    }

    public static enum Type {
        STANDALONE{

            @Override
            List<ObjectAdapter> load(EntityCollectionModel entityCollectionModel) {
                boolean bulkLoad = entityCollectionModel.getPersistenceSession().getConfiguration().getBoolean(EntityCollectionModel.KEY_BULK_LOAD, false);
                Iterable<ObjectAdapter> values = bulkLoad ? this.loadInBulk(entityCollectionModel) : this.loadOneByOne(entityCollectionModel);
                return Lists.newArrayList(values);
            }

            private Iterable<ObjectAdapter> loadInBulk(EntityCollectionModel model) {
                List mementoList = model.mementoList;
                PersistenceSession persistenceSession = model.getPersistenceSession();
                ImmutableList rootOids = FluentIterable.from((Iterable)mementoList).transform(ObjectAdapterMemento.Functions.toOid()).toList();
                Map adaptersByOid = persistenceSession.adaptersFor((List)rootOids);
                Collection adapterList = adaptersByOid.values();
                return FluentIterable.from(adapterList).filter(Predicates.notNull());
            }

            private Iterable<ObjectAdapter> loadOneByOne(EntityCollectionModel model) {
                List mementoList = model.mementoList;
                return FluentIterable.from((Iterable)mementoList).transform(ObjectAdapterMemento.Functions.fromMemento(AdapterManager.ConcurrencyChecking.NO_CHECK, model.getPersistenceSession(), model.getSpecificationLoader())).filter(Predicates.notNull());
            }

            @Override
            void setObject(EntityCollectionModel entityCollectionModel, List<ObjectAdapter> list) {
                entityCollectionModel.mementoList = Lists.newArrayList((Iterable)Iterables.filter((Iterable)Iterables.transform(list, ObjectAdapterMemento.Functions.toMemento()), (Predicate)Predicates.notNull()));
            }

            @Override
            public String getId(EntityCollectionModel entityCollectionModel) {
                return null;
            }

            @Override
            public String getName(EntityCollectionModel model) {
                PluralFacet facet = (PluralFacet)model.getTypeOfSpecification().getFacet(PluralFacet.class);
                return (String)facet.value();
            }

            @Override
            public int getCount(EntityCollectionModel model) {
                return model.mementoList.size();
            }

            @Override
            public EntityModel.RenderingHint renderingHint() {
                return EntityModel.RenderingHint.STANDALONE_PROPERTY_COLUMN;
            }
        }
        ,
        PARENTED{

            @Override
            List<ObjectAdapter> load(EntityCollectionModel entityCollectionModel) {
                ObjectAdapter adapter = entityCollectionModel.getParentObjectAdapterMemento().getObjectAdapter(AdapterManager.ConcurrencyChecking.NO_CHECK, entityCollectionModel.getPersistenceSession(), entityCollectionModel.getSpecificationLoader());
                OneToManyAssociation collection = entityCollectionModel.collectionMemento.getCollection(entityCollectionModel.getSpecificationLoader());
                ObjectAdapter collectionAsAdapter = collection.get(adapter, InteractionInitiatedBy.USER);
                List<Object> objectList = this.asIterable(collectionAsAdapter);
                Class sortedBy = entityCollectionModel.sortedBy;
                if (sortedBy != null) {
                    Comparator comparator = (Comparator)InstanceUtil.createInstance((Class)sortedBy, (Object[])new Object[0]);
                    entityCollectionModel.getIsisSessionFactory().getServicesInjector().injectServicesInto((Object)comparator);
                    Collections.sort(objectList, comparator);
                }
                Iterable adapterIterable = Iterables.transform(objectList, (Function)ObjectAdapter.Functions.adapterForUsing((AdapterManager)entityCollectionModel.getPersistenceSession()));
                ArrayList adapterList = Lists.newArrayList((Iterable)adapterIterable);
                return adapterList;
            }

            private List<Object> asIterable(ObjectAdapter collectionAsAdapter) {
                Iterable objects = (Iterable)collectionAsAdapter.getObject();
                return Lists.newArrayList((Iterable)objects);
            }

            @Override
            void setObject(EntityCollectionModel entityCollectionModel, List<ObjectAdapter> list) {
                throw new UnsupportedOperationException();
            }

            @Override
            public String getId(EntityCollectionModel model) {
                return model.getCollectionMemento().getCollectionId();
            }

            @Override
            public String getName(EntityCollectionModel model) {
                return model.getCollectionMemento().getCollectionName();
            }

            @Override
            public int getCount(EntityCollectionModel model) {
                return this.load(model).size();
            }

            @Override
            public EntityModel.RenderingHint renderingHint() {
                return EntityModel.RenderingHint.PARENTED_PROPERTY_COLUMN;
            }
        };


        abstract List<ObjectAdapter> load(EntityCollectionModel var1);

        abstract void setObject(EntityCollectionModel var1, List<ObjectAdapter> var2);

        public abstract String getId(EntityCollectionModel var1);

        public abstract String getName(EntityCollectionModel var1);

        public abstract int getCount(EntityCollectionModel var1);

        public abstract EntityModel.RenderingHint renderingHint();
    }
}

