/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.model.models;

import org.apache.isis.viewer.wicket.model.models.ActionPrompt;
import org.apache.wicket.Component;
import org.apache.wicket.Page;

public interface ActionPromptProvider {
    public ActionPrompt getActionPrompt();

    public static class Util {
        public static ActionPromptProvider getFrom(Component component) {
            Page page = component.getPage();
            if (page == null) {
                throw new IllegalArgumentException("Programming error: component must be added to a page in order to locate the ActionPromptProvider");
            }
            return Util.getFrom(page);
        }

        public static ActionPromptProvider getFrom(Page page) {
            if (page instanceof ActionPromptProvider) {
                ActionPromptProvider provider = (ActionPromptProvider)page;
                return provider;
            }
            throw new IllegalArgumentException("Programming error: all pages should inherit from PageAbstract, which serves as the ActionPromptProvider");
        }
    }
}

