/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.model.models;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.isis.applib.Identifier;
import org.apache.isis.applib.annotation.BookmarkPolicy;
import org.apache.isis.applib.annotation.PromptStyle;
import org.apache.isis.applib.annotation.Where;
import org.apache.isis.applib.services.routing.RoutingService;
import org.apache.isis.applib.value.Blob;
import org.apache.isis.applib.value.Clob;
import org.apache.isis.applib.value.NamedWithMimeType;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.adapter.mgr.AdapterManager;
import org.apache.isis.core.metamodel.adapter.oid.OidMarshaller;
import org.apache.isis.core.metamodel.adapter.oid.RootOid;
import org.apache.isis.core.metamodel.consent.Consent;
import org.apache.isis.core.metamodel.consent.InteractionInitiatedBy;
import org.apache.isis.core.metamodel.facetapi.Facet;
import org.apache.isis.core.metamodel.facets.object.bookmarkpolicy.BookmarkPolicyFacet;
import org.apache.isis.core.metamodel.facets.object.encodeable.EncodableFacet;
import org.apache.isis.core.metamodel.facets.object.promptStyle.PromptStyleFacet;
import org.apache.isis.core.metamodel.services.ServicesInjector;
import org.apache.isis.core.metamodel.spec.ActionType;
import org.apache.isis.core.metamodel.spec.ObjectSpecId;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.core.metamodel.spec.feature.ObjectAction;
import org.apache.isis.core.metamodel.spec.feature.ObjectActionParameter;
import org.apache.isis.core.metamodel.specloader.SpecificationLoader;
import org.apache.isis.viewer.wicket.model.common.PageParametersUtils;
import org.apache.isis.viewer.wicket.model.mementos.ActionMemento;
import org.apache.isis.viewer.wicket.model.mementos.ActionParameterMemento;
import org.apache.isis.viewer.wicket.model.mementos.ObjectAdapterMemento;
import org.apache.isis.viewer.wicket.model.mementos.PageParameterNames;
import org.apache.isis.viewer.wicket.model.models.ActionArgumentModel;
import org.apache.isis.viewer.wicket.model.models.BookmarkableModel;
import org.apache.isis.viewer.wicket.model.models.EntityModel;
import org.apache.isis.viewer.wicket.model.models.FormExecutorContext;
import org.apache.isis.viewer.wicket.model.models.InlinePromptContext;
import org.apache.isis.viewer.wicket.model.models.ScalarModel;
import org.apache.wicket.request.IRequestHandler;
import org.apache.wicket.request.handler.resource.ResourceStreamRequestHandler;
import org.apache.wicket.request.http.handler.RedirectRequestHandler;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.apache.wicket.request.resource.ContentDisposition;
import org.apache.wicket.util.resource.AbstractResourceStream;
import org.apache.wicket.util.resource.IResourceStream;
import org.apache.wicket.util.resource.ResourceStreamNotFoundException;
import org.apache.wicket.util.resource.StringResourceStream;

public class ActionModel
extends BookmarkableModel<ObjectAdapter>
implements FormExecutorContext {
    private static final long serialVersionUID = 1L;
    private static final OidMarshaller OID_MARSHALLER = OidMarshaller.INSTANCE;
    private static final String NULL_ARG = "$nullArg$";
    private static final Pattern KEY_VALUE_PATTERN = Pattern.compile("([^=]+)=(.+)");
    private final EntityModel entityModel;
    private final ActionMemento actionMemento;
    private final Map<Integer, ActionArgumentModel> arguments = Maps.newHashMap();
    public static final Where WHERE_FOR_ACTION_INVOCATION = Where.ANYWHERE;
    private InlinePromptContext inlinePromptContext;

    public ActionModel copy() {
        return new ActionModel(this);
    }

    public static ActionModel create(EntityModel entityModel, ObjectAction action) {
        ActionMemento homePageActionMemento = (ActionMemento)ObjectAdapterMemento.Functions.fromAction().apply((Object)action);
        return new ActionModel(entityModel, homePageActionMemento);
    }

    public static ActionModel createForPersistent(PageParameters pageParameters, SpecificationLoader specificationLoader) {
        return new ActionModel(pageParameters, specificationLoader);
    }

    public static PageParameters createPageParameters(ObjectAdapter adapter, ObjectAction objectAction, AdapterManager.ConcurrencyChecking concurrencyChecking) {
        PageParameters pageParameters = PageParametersUtils.newPageParameters();
        String oidStr = concurrencyChecking == AdapterManager.ConcurrencyChecking.CHECK ? adapter.getOid().enString() : adapter.getOid().enStringNoVersion();
        PageParameterNames.OBJECT_OID.addStringTo(pageParameters, oidStr);
        ActionType actionType = objectAction.getType();
        PageParameterNames.ACTION_TYPE.addEnumTo(pageParameters, (Enum<?>)actionType);
        ObjectSpecification actionOnTypeSpec = objectAction.getOnType();
        if (actionOnTypeSpec != null) {
            PageParameterNames.ACTION_OWNING_SPEC.addStringTo(pageParameters, actionOnTypeSpec.getFullIdentifier());
        }
        String actionId = ActionModel.determineActionId(objectAction);
        PageParameterNames.ACTION_ID.addStringTo(pageParameters, actionId);
        return pageParameters;
    }

    public static Map.Entry<Integer, String> parse(String paramContext) {
        String oidStr;
        int paramNum;
        Matcher matcher = KEY_VALUE_PATTERN.matcher(paramContext);
        if (!matcher.matches()) {
            return null;
        }
        try {
            paramNum = Integer.parseInt(matcher.group(1));
        }
        catch (Exception e) {
            return null;
        }
        try {
            oidStr = matcher.group(2);
        }
        catch (Exception e) {
            return null;
        }
        return new Map.Entry<Integer, String>(){

            @Override
            public Integer getKey() {
                return paramNum;
            }

            @Override
            public String getValue() {
                return oidStr;
            }

            @Override
            public String setValue(String value) {
                return null;
            }
        };
    }

    @Override
    public PageParameters getPageParametersWithoutUiHints() {
        ObjectAdapter[] argumentsAsArray;
        ObjectAdapter adapter = this.getTargetAdapter();
        ObjectAction objectAction = this.getAction();
        PageParameters pageParameters = ActionModel.createPageParameters(adapter, objectAction, AdapterManager.ConcurrencyChecking.NO_CHECK);
        for (ObjectAdapter argumentAdapter : argumentsAsArray = this.getArgumentsAsArray()) {
            String encodedArg = this.encodeArg(argumentAdapter);
            PageParameterNames.ACTION_ARGS.addStringTo(pageParameters, encodedArg);
        }
        return pageParameters;
    }

    @Override
    public PageParameters getPageParameters() {
        return this.getPageParametersWithoutUiHints();
    }

    @Override
    public String getTitle() {
        ObjectAdapter[] argumentsAsArray;
        ObjectAdapter adapter = this.getTargetAdapter();
        ObjectAction objectAction = this.getAction();
        StringBuilder buf = new StringBuilder();
        for (ObjectAdapter argumentAdapter : argumentsAsArray = this.getArgumentsAsArray()) {
            if (buf.length() > 0) {
                buf.append(",");
            }
            buf.append(ActionModel.abbreviated(ActionModel.titleOf(argumentAdapter), 8));
        }
        return adapter.titleString(null) + "." + objectAction.getName() + (buf.length() > 0 ? "(" + buf.toString() + ")" : "");
    }

    @Override
    public boolean hasAsRootPolicy() {
        return true;
    }

    private static String titleOf(ObjectAdapter argumentAdapter) {
        return argumentAdapter != null ? argumentAdapter.titleString(null) : "";
    }

    private static String abbreviated(String str, int maxLength) {
        return str.length() < maxLength ? str : str.substring(0, maxLength - 3) + "...";
    }

    private static String determineActionId(ObjectAction objectAction) {
        Identifier identifier = objectAction.getIdentifier();
        if (identifier != null) {
            return identifier.toNameParmsIdentityString();
        }
        return objectAction.getId();
    }

    private ActionModel(PageParameters pageParameters, SpecificationLoader specificationLoader) {
        this(ActionModel.newEntityModelFrom(pageParameters), ActionModel.newActionMementoFrom(pageParameters, specificationLoader));
        this.setArgumentsIfPossible(pageParameters);
        this.setContextArgumentIfPossible(pageParameters);
    }

    private static ActionMemento newActionMementoFrom(PageParameters pageParameters, SpecificationLoader specificationLoader) {
        ObjectSpecId owningSpec = ObjectSpecId.of((String)PageParameterNames.ACTION_OWNING_SPEC.getStringFrom(pageParameters));
        ActionType actionType = PageParameterNames.ACTION_TYPE.getEnumFrom(pageParameters, ActionType.class);
        String actionNameParms = PageParameterNames.ACTION_ID.getStringFrom(pageParameters);
        return new ActionMemento(owningSpec, actionType, actionNameParms, specificationLoader);
    }

    private static EntityModel newEntityModelFrom(PageParameters pageParameters) {
        RootOid oid = ActionModel.oidFor(pageParameters);
        if (oid.isTransient()) {
            return null;
        }
        return new EntityModel(ObjectAdapterMemento.createPersistent(oid));
    }

    private static RootOid oidFor(PageParameters pageParameters) {
        String oidStr = PageParameterNames.OBJECT_OID.getStringFrom(pageParameters);
        return (RootOid)OID_MARSHALLER.unmarshal(oidStr, RootOid.class);
    }

    private ActionModel(EntityModel entityModel, ActionMemento actionMemento) {
        this.entityModel = entityModel;
        this.actionMemento = actionMemento;
    }

    @Override
    public EntityModel getParentEntityModel() {
        return this.entityModel;
    }

    private ActionModel(ActionModel actionModel) {
        this.entityModel = actionModel.entityModel;
        this.actionMemento = actionModel.actionMemento;
        this.primeArgumentModels();
        Map<Integer, ActionArgumentModel> argumentModelByIdx = actionModel.arguments;
        for (Map.Entry<Integer, ActionArgumentModel> argumentModel : argumentModelByIdx.entrySet()) {
            this.setArgument(argumentModel.getKey(), (ObjectAdapter)argumentModel.getValue().getObject());
        }
    }

    private void setArgumentsIfPossible(PageParameters pageParameters) {
        List<String> args = PageParameterNames.ACTION_ARGS.getListFrom(pageParameters);
        ObjectAction action = this.actionMemento.getAction(this.getSpecificationLoader());
        List parameterTypes = action.getParameterTypes();
        for (int paramNum = 0; paramNum < args.size(); ++paramNum) {
            String encoded = args.get(paramNum);
            this.setArgument(paramNum, (ObjectSpecification)parameterTypes.get(paramNum), encoded);
        }
    }

    private ObjectAction getAction() {
        return this.getActionMemento().getAction(this.getSpecificationLoader());
    }

    public boolean hasParameters() {
        return this.getAction().getParameterCount() > 0;
    }

    private boolean setContextArgumentIfPossible(PageParameters pageParameters) {
        String paramContext = PageParameterNames.ACTION_PARAM_CONTEXT.getStringFrom(pageParameters);
        if (paramContext == null) {
            return false;
        }
        ObjectAction action = this.actionMemento.getAction(this.getSpecificationLoader());
        List parameterTypes = action.getParameterTypes();
        int parameterCount = parameterTypes.size();
        Map.Entry<Integer, String> mapEntry = ActionModel.parse(paramContext);
        int paramNum = mapEntry.getKey();
        if (paramNum >= parameterCount) {
            return false;
        }
        String encoded = mapEntry.getValue();
        this.setArgument(paramNum, (ObjectSpecification)parameterTypes.get(paramNum), encoded);
        return true;
    }

    private void setArgument(int paramNum, ObjectSpecification argSpec, String encoded) {
        ObjectAdapter argumentAdapter = this.decodeArg(argSpec, encoded);
        this.setArgument(paramNum, argumentAdapter);
    }

    private String encodeArg(ObjectAdapter adapter) {
        if (adapter == null) {
            return NULL_ARG;
        }
        ObjectSpecification objSpec = adapter.getSpecification();
        if (objSpec.isEncodeable()) {
            EncodableFacet encodeable = (EncodableFacet)objSpec.getFacet(EncodableFacet.class);
            return encodeable.toEncodedString(adapter);
        }
        return adapter.getOid().enStringNoVersion();
    }

    private ObjectAdapter decodeArg(ObjectSpecification objSpec, String encoded) {
        if (NULL_ARG.equals(encoded)) {
            return null;
        }
        if (objSpec.isEncodeable()) {
            EncodableFacet encodeable = (EncodableFacet)objSpec.getFacet(EncodableFacet.class);
            return encodeable.fromEncodedString(encoded);
        }
        try {
            RootOid oid = RootOid.deStringEncoded((String)encoded);
            return this.getPersistenceSession().adapterFor(oid);
        }
        catch (Exception e) {
            return null;
        }
    }

    private void setArgument(int paramNum, ObjectAdapter argumentAdapter) {
        ObjectAction action = this.actionMemento.getAction(this.getSpecificationLoader());
        ObjectActionParameter actionParam = (ObjectActionParameter)action.getParameters().get(paramNum);
        ActionParameterMemento apm = new ActionParameterMemento(actionParam);
        ActionArgumentModel actionArgumentModel = this.getArgumentModel(apm);
        actionArgumentModel.setObject(argumentAdapter);
    }

    public ActionArgumentModel getArgumentModel(ActionParameterMemento apm) {
        int i = apm.getNumber();
        ActionArgumentModel actionArgumentModel = this.arguments.get(i);
        if (actionArgumentModel == null) {
            actionArgumentModel = new ScalarModel(this.entityModel, apm);
            int number = actionArgumentModel.getParameterMemento().getNumber();
            this.arguments.put(number, actionArgumentModel);
        }
        return actionArgumentModel;
    }

    public ObjectAdapter getTargetAdapter() {
        return this.entityModel.load(this.getConcurrencyChecking());
    }

    protected AdapterManager.ConcurrencyChecking getConcurrencyChecking() {
        return this.actionMemento.getConcurrencyChecking();
    }

    public ActionMemento getActionMemento() {
        return this.actionMemento;
    }

    protected ObjectAdapter load() {
        this.detach();
        ObjectAdapter results = this.executeAction();
        return results;
    }

    private ObjectAdapter executeAction() {
        ObjectAdapter targetAdapter = this.getTargetAdapter();
        ObjectAdapter[] arguments = this.getArgumentsAsArray();
        ObjectAction action = this.getAction();
        ObjectAdapter mixedInAdapter = null;
        ObjectAdapter resultAdapter = action.executeWithRuleChecking(targetAdapter, mixedInAdapter, arguments, InteractionInitiatedBy.USER, WHERE_FOR_ACTION_INVOCATION);
        List routingServices = this.getServicesInjector().lookupServices(RoutingService.class);
        Object result = resultAdapter != null ? resultAdapter.getObject() : null;
        for (RoutingService routingService : routingServices) {
            boolean canRoute = routingService.canRoute(result);
            if (!canRoute) continue;
            Object routeTo = routingService.route(result);
            return routeTo != null ? this.getPersistenceSession().adapterFor(routeTo) : null;
        }
        return resultAdapter;
    }

    public String getReasonDisabledIfAny() {
        ObjectAdapter targetAdapter = this.getTargetAdapter();
        ObjectAction objectAction = this.getAction();
        Consent usability = objectAction.isUsable(targetAdapter, InteractionInitiatedBy.USER, Where.OBJECT_FORMS);
        String disabledReasonIfAny = usability.getReason();
        return disabledReasonIfAny;
    }

    public boolean isVisible() {
        ObjectAdapter targetAdapter = this.getTargetAdapter();
        ObjectAction objectAction = this.getAction();
        Consent visibility = objectAction.isVisible(targetAdapter, InteractionInitiatedBy.USER, Where.OBJECT_FORMS);
        return visibility.isAllowed();
    }

    public String getReasonInvalidIfAny() {
        ObjectAdapter targetAdapter = this.getTargetAdapter();
        ObjectAdapter[] proposedArguments = this.getArgumentsAsArray();
        ObjectAction objectAction = this.getAction();
        Consent validity = objectAction.isProposedArgumentSetValid(targetAdapter, proposedArguments, InteractionInitiatedBy.USER);
        return validity.isAllowed() ? null : validity.getReason();
    }

    public void setObject(ObjectAdapter object) {
        throw new UnsupportedOperationException("target adapter for ActionModel cannot be changed");
    }

    public ObjectAdapter[] getArgumentsAsArray() {
        if (this.arguments.size() < this.getAction().getParameterCount()) {
            this.primeArgumentModels();
        }
        ObjectAction objectAction = this.getAction();
        ObjectAdapter[] arguments = new ObjectAdapter[objectAction.getParameterCount()];
        for (int i = 0; i < arguments.length; ++i) {
            ActionArgumentModel actionArgumentModel = this.arguments.get(i);
            arguments[i] = (ObjectAdapter)actionArgumentModel.getObject();
        }
        return arguments;
    }

    @Override
    public void reset() {
    }

    @Override
    public boolean isWithinPrompt() {
        return FormExecutorContext.Util.isWithinPrompt(this);
    }

    public void clearArguments() {
        for (ActionArgumentModel actionArgumentModel : this.arguments.values()) {
            actionArgumentModel.reset();
        }
    }

    public boolean isBookmarkable() {
        ObjectAction action = this.getAction();
        BookmarkPolicyFacet bookmarkPolicy = (BookmarkPolicyFacet)action.getFacet(BookmarkPolicyFacet.class);
        boolean safeSemantics = action.getSemantics().isSafeInNature();
        return bookmarkPolicy.value() == BookmarkPolicy.AS_ROOT && safeSemantics;
    }

    public ObjectAdapter execute() {
        ObjectAdapter resultAdapter = (ObjectAdapter)this.getObject();
        return resultAdapter;
    }

    public static IRequestHandler redirectHandler(Object value) {
        if (value instanceof URL) {
            URL url = (URL)value;
            return new RedirectRequestHandler(url.toString());
        }
        return null;
    }

    public static IRequestHandler downloadHandler(Object value) {
        if (value instanceof Clob) {
            Clob clob = (Clob)value;
            return ActionModel.handlerFor(ActionModel.resourceStreamFor(clob), (NamedWithMimeType)clob);
        }
        if (value instanceof Blob) {
            Blob blob = (Blob)value;
            return ActionModel.handlerFor(ActionModel.resourceStreamFor(blob), (NamedWithMimeType)blob);
        }
        return null;
    }

    private static IResourceStream resourceStreamFor(final Blob blob) {
        AbstractResourceStream resourceStream = new AbstractResourceStream(){
            private static final long serialVersionUID = 1L;

            public InputStream getInputStream() throws ResourceStreamNotFoundException {
                return new ByteArrayInputStream(blob.getBytes());
            }

            public String getContentType() {
                return blob.getMimeType().toString();
            }

            public void close() throws IOException {
            }
        };
        return resourceStream;
    }

    private static IResourceStream resourceStreamFor(Clob clob) {
        StringResourceStream resourceStream = new StringResourceStream(clob.getChars(), clob.getMimeType().toString());
        return resourceStream;
    }

    private static IRequestHandler handlerFor(IResourceStream resourceStream, NamedWithMimeType namedWithMimeType) {
        ResourceStreamRequestHandler handler = new ResourceStreamRequestHandler(resourceStream, namedWithMimeType.getName());
        handler.setContentDisposition(ContentDisposition.ATTACHMENT);
        return handler;
    }

    public List<ActionParameterMemento> primeArgumentModels() {
        ObjectAction objectAction = this.getAction();
        List parameters = objectAction.getParameters();
        List<ActionParameterMemento> mementos = ActionModel.buildParameterMementos(parameters);
        for (ActionParameterMemento apm : mementos) {
            this.getArgumentModel(apm);
        }
        return mementos;
    }

    private static List<ActionParameterMemento> buildParameterMementos(List<ObjectActionParameter> parameters) {
        List parameterMementoList = Lists.transform(parameters, ObjectAdapterMemento.Functions.fromActionParameter());
        return Lists.newArrayList((Iterable)parameterMementoList);
    }

    @Override
    public PromptStyle getPromptStyle() {
        ObjectAction objectAction = this.getAction();
        ObjectSpecification objectActionOwner = objectAction.getOnType();
        if (objectActionOwner.isService()) {
            return PromptStyle.DIALOG;
        }
        if (objectAction.getParameterCount() == 0) {
            return PromptStyle.DIALOG;
        }
        PromptStyleFacet facet = this.getFacet(PromptStyleFacet.class);
        if (facet == null) {
            return PromptStyle.INLINE;
        }
        PromptStyle promptStyle = facet.value();
        if (promptStyle == PromptStyle.AS_CONFIGURED) {
            return PromptStyle.INLINE;
        }
        return promptStyle;
    }

    public <T extends Facet> T getFacet(Class<T> facetType) {
        ObjectAction facetHolder = this.getAction();
        return (T)facetHolder.getFacet(facetType);
    }

    @Override
    public InlinePromptContext getInlinePromptContext() {
        return this.inlinePromptContext;
    }

    public void setInlinePromptContext(InlinePromptContext inlinePromptContext) {
        this.inlinePromptContext = inlinePromptContext;
    }

    ServicesInjector getServicesInjector() {
        return this.getIsisSessionFactory().getServicesInjector();
    }
}

