/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.model.mementos;

import com.google.common.base.Function;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.isis.applib.services.bookmark.Bookmark;
import org.apache.isis.applib.services.hint.HintStore;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.adapter.mgr.AdapterManager;
import org.apache.isis.core.metamodel.adapter.oid.Oid;
import org.apache.isis.core.metamodel.adapter.oid.OidMarshaller;
import org.apache.isis.core.metamodel.adapter.oid.RootOid;
import org.apache.isis.core.metamodel.facets.object.encodeable.EncodableFacet;
import org.apache.isis.core.metamodel.spec.ObjectSpecId;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.core.metamodel.spec.feature.ObjectAction;
import org.apache.isis.core.metamodel.spec.feature.ObjectActionParameter;
import org.apache.isis.core.metamodel.spec.feature.OneToManyAssociation;
import org.apache.isis.core.metamodel.spec.feature.OneToOneAssociation;
import org.apache.isis.core.metamodel.specloader.SpecificationLoader;
import org.apache.isis.core.runtime.memento.Memento;
import org.apache.isis.core.runtime.persistence.ObjectNotFoundException;
import org.apache.isis.core.runtime.system.persistence.PersistenceSession;
import org.apache.isis.core.runtime.system.session.IsisSessionFactory;
import org.apache.isis.viewer.wicket.model.mementos.ActionMemento;
import org.apache.isis.viewer.wicket.model.mementos.ActionParameterMemento;
import org.apache.isis.viewer.wicket.model.mementos.CollectionMemento;
import org.apache.isis.viewer.wicket.model.mementos.PropertyMemento;
import org.apache.isis.viewer.wicket.model.mementos.SpecUtils;

public class ObjectAdapterMemento
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final OidMarshaller OID_MARSHALLER = OidMarshaller.INSTANCE;
    private final Sort sort;
    private final ObjectSpecId objectSpecId;
    private Type type;
    private String titleHint;
    private String encodableValue;
    private String persistentOidStr;
    private Bookmark bookmark;
    private String hintId;
    private Memento transientMemento;
    private ArrayList<ObjectAdapterMemento> list;

    public static ObjectAdapterMemento createOrNull(ObjectAdapter adapter) {
        if (adapter == null) {
            return null;
        }
        Object object = adapter.getObject();
        if (object == null) {
            return null;
        }
        return new ObjectAdapterMemento(adapter);
    }

    public static ObjectAdapterMemento createPersistent(RootOid rootOid) {
        return new ObjectAdapterMemento(rootOid);
    }

    public static ObjectAdapterMemento createForList(ArrayList<ObjectAdapterMemento> list, ObjectSpecId objectSpecId) {
        return new ObjectAdapterMemento(list, objectSpecId);
    }

    public static ObjectAdapterMemento createForList(Collection<ObjectAdapterMemento> list, ObjectSpecId objectSpecId) {
        return list != null ? ObjectAdapterMemento.createForList(Lists.newArrayList(list), objectSpecId) : null;
    }

    public ObjectAdapterMemento(ArrayList<ObjectAdapterMemento> list, ObjectSpecId objectSpecId) {
        this.sort = Sort.VECTOR;
        this.list = list;
        this.objectSpecId = objectSpecId;
    }

    private ObjectAdapterMemento(RootOid rootOid) {
        assert (!rootOid.isTransient());
        this.sort = Sort.SCALAR;
        this.persistentOidStr = rootOid.enString();
        this.bookmark = rootOid.asBookmark();
        this.objectSpecId = rootOid.getObjectSpecId();
        this.type = Type.PERSISTENT;
    }

    private ObjectAdapterMemento(ObjectAdapter adapter) {
        if (adapter == null) {
            throw new IllegalArgumentException("adapter cannot be null");
        }
        this.sort = Sort.SCALAR;
        ObjectSpecification specification = adapter.getSpecification();
        this.objectSpecId = specification.getSpecId();
        this.init(adapter);
    }

    private void init(ObjectAdapter adapter) {
        boolean isEncodable;
        ObjectSpecification specification = adapter.getSpecification();
        EncodableFacet encodableFacet = (EncodableFacet)specification.getFacet(EncodableFacet.class);
        boolean bl = isEncodable = encodableFacet != null;
        if (isEncodable) {
            this.encodableValue = encodableFacet.toEncodedString(adapter);
            this.type = Type.ENCODEABLE;
            return;
        }
        RootOid oid = (RootOid)adapter.getOid();
        if (oid.isTransient()) {
            this.transientMemento = new Memento(adapter);
            this.type = Type.TRANSIENT;
            return;
        }
        this.persistentOidStr = oid.enString();
        this.bookmark = oid.asBookmark();
        if (adapter.getObject() instanceof HintStore.HintIdProvider) {
            HintStore.HintIdProvider provider = (HintStore.HintIdProvider)adapter.getObject();
            this.hintId = provider.hintId();
        }
        this.type = Type.PERSISTENT;
    }

    public Sort getSort() {
        return this.sort;
    }

    public ArrayList<ObjectAdapterMemento> getList() {
        this.ensureVector();
        return this.list;
    }

    public void resetVersion(PersistenceSession persistenceSession, SpecificationLoader specificationLoader) {
        this.ensureScalar();
        this.type.resetVersion(this, persistenceSession, specificationLoader);
    }

    public Bookmark asBookmark() {
        this.ensureScalar();
        return this.bookmark;
    }

    public Bookmark asHintingBookmark() {
        Bookmark bookmark = this.asBookmark();
        return this.hintId != null && bookmark != null ? new HintStore.BookmarkWithHintId(bookmark, this.hintId) : bookmark;
    }

    public ObjectAdapter getObjectAdapter(AdapterManager.ConcurrencyChecking concurrencyChecking, PersistenceSession persistenceSession, SpecificationLoader specificationLoader) {
        return this.sort.asAdapter(this, concurrencyChecking, persistenceSession, specificationLoader);
    }

    public void setAdapter(ObjectAdapter adapter) {
        this.ensureScalar();
        this.init(adapter);
    }

    public ObjectSpecId getObjectSpecId() {
        return this.objectSpecId;
    }

    public boolean containedIn(List<ObjectAdapterMemento> list, PersistenceSession persistenceSession, SpecificationLoader specificationLoader) {
        this.ensureScalar();
        ObjectAdapter currAdapter = this.getObjectAdapter(AdapterManager.ConcurrencyChecking.NO_CHECK, persistenceSession, specificationLoader);
        for (ObjectAdapterMemento each : list) {
            ObjectAdapter otherAdapter;
            if (each == null || currAdapter != (otherAdapter = each.getObjectAdapter(AdapterManager.ConcurrencyChecking.NO_CHECK, persistenceSession, specificationLoader))) continue;
            return true;
        }
        return false;
    }

    public int hashCode() {
        return this.sort.hashCode(this);
    }

    public boolean equals(Object obj) {
        return this.sort.equals(this, obj);
    }

    public String toString() {
        return this.asString();
    }

    public String asString() {
        return this.sort.asString(this);
    }

    private void ensureScalar() {
        this.getSort().ensure(Sort.SCALAR);
    }

    private void ensureVector() {
        this.getSort().ensure(Sort.VECTOR);
    }

    public static final class Functions {
        private Functions() {
        }

        public static Function<ObjectSpecification, ObjectSpecId> fromSpec() {
            return new Function<ObjectSpecification, ObjectSpecId>(){

                public ObjectSpecId apply(ObjectSpecification from) {
                    return from.getSpecId();
                }
            };
        }

        public static Function<OneToOneAssociation, PropertyMemento> fromProperty(final IsisSessionFactory isisSessionFactory) {
            return new Function<OneToOneAssociation, PropertyMemento>(){

                public PropertyMemento apply(OneToOneAssociation from) {
                    return new PropertyMemento(from, isisSessionFactory);
                }
            };
        }

        public static Function<OneToManyAssociation, CollectionMemento> fromCollection(final IsisSessionFactory isisSessionFactory) {
            return new Function<OneToManyAssociation, CollectionMemento>(){

                public CollectionMemento apply(OneToManyAssociation from) {
                    return new CollectionMemento(from, isisSessionFactory);
                }
            };
        }

        public static Function<ObjectAction, ActionMemento> fromAction() {
            return new Function<ObjectAction, ActionMemento>(){

                public ActionMemento apply(ObjectAction from) {
                    return new ActionMemento(from);
                }
            };
        }

        public static Function<ObjectActionParameter, ActionParameterMemento> fromActionParameter() {
            return new Function<ObjectActionParameter, ActionParameterMemento>(){

                public ActionParameterMemento apply(ObjectActionParameter from) {
                    return new ActionParameterMemento(from);
                }
            };
        }

        public static Function<Object, ObjectAdapterMemento> fromPojo(final AdapterManager adapterManager) {
            return new Function<Object, ObjectAdapterMemento>(){

                public ObjectAdapterMemento apply(Object pojo) {
                    ObjectAdapter adapter = adapterManager.adapterFor(pojo);
                    return ObjectAdapterMemento.createOrNull(adapter);
                }
            };
        }

        public static Function<ObjectAdapter, ObjectAdapterMemento> fromAdapter() {
            return new Function<ObjectAdapter, ObjectAdapterMemento>(){

                public ObjectAdapterMemento apply(ObjectAdapter adapter) {
                    return ObjectAdapterMemento.createOrNull(adapter);
                }
            };
        }

        public static Function<ObjectAdapterMemento, ObjectAdapter> fromMemento(final AdapterManager.ConcurrencyChecking concurrencyChecking, final PersistenceSession persistenceSession, final SpecificationLoader specificationLoader) {
            return new Function<ObjectAdapterMemento, ObjectAdapter>(){

                public ObjectAdapter apply(ObjectAdapterMemento memento) {
                    try {
                        return memento.getObjectAdapter(concurrencyChecking, persistenceSession, specificationLoader);
                    }
                    catch (ObjectNotFoundException e) {
                        return null;
                    }
                }
            };
        }

        public static Function<ObjectAdapter, ObjectAdapterMemento> toMemento() {
            return new Function<ObjectAdapter, ObjectAdapterMemento>(){

                public ObjectAdapterMemento apply(ObjectAdapter from) {
                    return ObjectAdapterMemento.createOrNull(from);
                }
            };
        }

        public static Function<? super ObjectAdapterMemento, Object> toPojo(final PersistenceSession persistenceSession, final SpecificationLoader specificationLoader) {
            return new Function<ObjectAdapterMemento, Object>(){

                @Nullable
                public Object apply(@Nullable ObjectAdapterMemento input) {
                    if (input == null) {
                        return null;
                    }
                    ObjectAdapter objectAdapter = input.getObjectAdapter(AdapterManager.ConcurrencyChecking.NO_CHECK, persistenceSession, specificationLoader);
                    if (objectAdapter == null) {
                        return null;
                    }
                    return objectAdapter.getObject();
                }
            };
        }

        public static Function<ObjectAdapterMemento, RootOid> toOid() {
            return new Function<ObjectAdapterMemento, RootOid>(){

                public RootOid apply(ObjectAdapterMemento objectAdapterMemento) {
                    return RootOid.create((Bookmark)objectAdapterMemento.asBookmark());
                }
            };
        }
    }

    static enum Type {
        ENCODEABLE{

            @Override
            ObjectAdapter recreateAdapter(ObjectAdapterMemento oam, AdapterManager.ConcurrencyChecking concurrencyChecking, PersistenceSession persistenceSession, SpecificationLoader specificationLoader) {
                ObjectSpecId objectSpecId = oam.objectSpecId;
                ObjectSpecification objectSpec = SpecUtils.getSpecificationFor(objectSpecId, specificationLoader);
                EncodableFacet encodableFacet = (EncodableFacet)objectSpec.getFacet(EncodableFacet.class);
                return encodableFacet.fromEncodedString(oam.encodableValue);
            }

            @Override
            public boolean equals(ObjectAdapterMemento oam, ObjectAdapterMemento other) {
                return other.type == ENCODEABLE && oam.encodableValue.equals(other.encodableValue);
            }

            @Override
            public int hashCode(ObjectAdapterMemento oam) {
                return oam.encodableValue.hashCode();
            }

            @Override
            public String toString(ObjectAdapterMemento oam) {
                return oam.encodableValue;
            }

            @Override
            public void resetVersion(ObjectAdapterMemento objectAdapterMemento, PersistenceSession persistenceSession, SpecificationLoader specificationLoader) {
            }
        }
        ,
        PERSISTENT{

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            ObjectAdapter recreateAdapter(ObjectAdapterMemento oam, AdapterManager.ConcurrencyChecking concurrencyChecking, PersistenceSession persistenceSession, SpecificationLoader specificationLoader) {
                RootOid oid = (RootOid)OID_MARSHALLER.unmarshal(oam.persistentOidStr, RootOid.class);
                try {
                    ObjectAdapter adapter;
                    ObjectAdapter objectAdapter = adapter = persistenceSession.adapterFor(oid, concurrencyChecking);
                    return objectAdapter;
                }
                finally {
                    oam.persistentOidStr = oid.enString();
                }
            }

            @Override
            public void resetVersion(ObjectAdapterMemento oam, PersistenceSession persistenceSession, SpecificationLoader specificationLoader) {
                ObjectAdapter adapter = this.recreateAdapter(oam, AdapterManager.ConcurrencyChecking.NO_CHECK, persistenceSession, specificationLoader);
                Oid oid = adapter.getOid();
                oam.persistentOidStr = oid.enString();
            }

            @Override
            public boolean equals(ObjectAdapterMemento oam, ObjectAdapterMemento other) {
                return other.type == PERSISTENT && oam.persistentOidStr.equals(other.persistentOidStr);
            }

            @Override
            public int hashCode(ObjectAdapterMemento oam) {
                return oam.persistentOidStr.hashCode();
            }

            @Override
            public String toString(ObjectAdapterMemento oam) {
                return oam.persistentOidStr;
            }
        }
        ,
        TRANSIENT{

            @Override
            ObjectAdapter recreateAdapter(ObjectAdapterMemento oam, AdapterManager.ConcurrencyChecking concurrencyChecking, PersistenceSession persistenceSession, SpecificationLoader specificationLoader) {
                return oam.transientMemento.recreateObject();
            }

            @Override
            public boolean equals(ObjectAdapterMemento oam, ObjectAdapterMemento other) {
                return other.type == TRANSIENT && oam.transientMemento.equals(other.transientMemento);
            }

            @Override
            public int hashCode(ObjectAdapterMemento oam) {
                return oam.transientMemento.hashCode();
            }

            @Override
            public String toString(ObjectAdapterMemento oam) {
                return oam.transientMemento.toString();
            }

            @Override
            public void resetVersion(ObjectAdapterMemento objectAdapterMemento, PersistenceSession persistenceSession, SpecificationLoader specificationLoader) {
            }
        };


        public ObjectAdapter getAdapter(ObjectAdapterMemento nom, AdapterManager.ConcurrencyChecking concurrencyChecking, PersistenceSession persistenceSession, SpecificationLoader specificationLoader) {
            return this.recreateAdapter(nom, concurrencyChecking, persistenceSession, specificationLoader);
        }

        abstract ObjectAdapter recreateAdapter(ObjectAdapterMemento var1, AdapterManager.ConcurrencyChecking var2, PersistenceSession var3, SpecificationLoader var4);

        public abstract boolean equals(ObjectAdapterMemento var1, ObjectAdapterMemento var2);

        public abstract int hashCode(ObjectAdapterMemento var1);

        public abstract String toString(ObjectAdapterMemento var1);

        public abstract void resetVersion(ObjectAdapterMemento var1, PersistenceSession var2, SpecificationLoader var3);
    }

    static enum Sort {
        SCALAR{

            @Override
            public ObjectAdapter asAdapter(ObjectAdapterMemento oam, AdapterManager.ConcurrencyChecking concurrencyChecking, PersistenceSession persistenceSession, SpecificationLoader specificationLoader) {
                return oam.type.getAdapter(oam, concurrencyChecking, persistenceSession, specificationLoader);
            }

            @Override
            public int hashCode(ObjectAdapterMemento oam) {
                return oam.type.hashCode(oam);
            }

            @Override
            public boolean equals(ObjectAdapterMemento oam, Object other) {
                if (!(other instanceof ObjectAdapterMemento)) {
                    return false;
                }
                ObjectAdapterMemento otherOam = (ObjectAdapterMemento)other;
                if (otherOam.sort != SCALAR) {
                    return false;
                }
                return oam.type.equals(oam, (ObjectAdapterMemento)other);
            }

            @Override
            public String asString(ObjectAdapterMemento oam) {
                return oam.type.toString(oam);
            }
        }
        ,
        VECTOR{

            @Override
            public ObjectAdapter asAdapter(ObjectAdapterMemento oam, AdapterManager.ConcurrencyChecking concurrencyChecking, PersistenceSession persistenceSession, SpecificationLoader specificationLoader) {
                ArrayList listOfPojos = Lists.newArrayList((Iterable)FluentIterable.from((Iterable)oam.list).transform(Functions.toPojo(persistenceSession, specificationLoader)).toList());
                return (ObjectAdapter)ObjectAdapter.Functions.adapterForUsing((AdapterManager)persistenceSession).apply((Object)listOfPojos);
            }

            @Override
            public int hashCode(ObjectAdapterMemento oam) {
                return oam.list.hashCode();
            }

            @Override
            public boolean equals(ObjectAdapterMemento oam, Object other) {
                if (!(other instanceof ObjectAdapterMemento)) {
                    return false;
                }
                ObjectAdapterMemento otherOam = (ObjectAdapterMemento)other;
                if (otherOam.sort != VECTOR) {
                    return false;
                }
                return oam.list.equals(otherOam.list);
            }

            @Override
            public String asString(ObjectAdapterMemento oam) {
                return oam.list.toString();
            }
        };


        void ensure(Sort sort) {
            if (this == sort) {
                return;
            }
            throw new IllegalStateException("Memento is not for " + (Object)((Object)sort));
        }

        public abstract ObjectAdapter asAdapter(ObjectAdapterMemento var1, AdapterManager.ConcurrencyChecking var2, PersistenceSession var3, SpecificationLoader var4);

        public abstract int hashCode(ObjectAdapterMemento var1);

        public abstract boolean equals(ObjectAdapterMemento var1, Object var2);

        public abstract String asString(ObjectAdapterMemento var1);
    }
}

