/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.model.mementos;

import java.io.Serializable;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.core.metamodel.spec.feature.ObjectAction;
import org.apache.isis.core.metamodel.spec.feature.ObjectActionParameter;
import org.apache.isis.core.metamodel.specloader.SpecificationLoader;
import org.apache.isis.viewer.wicket.model.mementos.ActionMemento;

public class ActionParameterMemento
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final ActionMemento actionMemento;
    private final int number;
    private transient ObjectActionParameter actionParameter;

    public ActionParameterMemento(ActionMemento actionMemento, int number, SpecificationLoader specificationLoader) {
        this(actionMemento, number, ActionParameterMemento.actionParameterFor(actionMemento, number, specificationLoader));
    }

    public ActionParameterMemento(ObjectActionParameter actionParameter) {
        this(new ActionMemento(actionParameter.getAction()), actionParameter.getNumber(), actionParameter);
    }

    private ActionParameterMemento(ActionMemento actionMemento, int number, ObjectActionParameter actionParameter) {
        this.actionMemento = actionMemento;
        this.number = number;
        this.actionParameter = actionParameter;
    }

    public ActionMemento getActionMemento() {
        return this.actionMemento;
    }

    public int getNumber() {
        return this.number;
    }

    public ObjectActionParameter getActionParameter(SpecificationLoader specificationLoader) {
        if (this.actionParameter == null) {
            this.actionParameter = ActionParameterMemento.actionParameterFor(this.actionMemento, this.number, specificationLoader);
        }
        return this.actionParameter;
    }

    private static ObjectActionParameter actionParameterFor(ActionMemento actionMemento, int number, SpecificationLoader specificationLoader) {
        ObjectAction action = actionMemento.getAction(specificationLoader);
        return (ObjectActionParameter)action.getParameters().get(number);
    }

    public ObjectSpecification getSpecification(SpecificationLoader specificationLoader) {
        return this.getActionParameter(specificationLoader).getSpecification();
    }

    public String toString() {
        return this.getActionMemento().getNameParmsId() + "#" + this.getNumber();
    }
}

