/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.model.mementos;

import java.io.Serializable;
import org.apache.isis.applib.annotation.ActionSemantics;
import org.apache.isis.core.metamodel.adapter.mgr.AdapterManager;
import org.apache.isis.core.metamodel.spec.ActionType;
import org.apache.isis.core.metamodel.spec.ObjectSpecId;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.core.metamodel.spec.feature.ObjectAction;
import org.apache.isis.core.metamodel.specloader.SpecificationLoader;
import org.apache.isis.viewer.wicket.model.mementos.SpecUtils;

public class ActionMemento
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final ObjectSpecId owningType;
    private final ActionType actionType;
    private final String nameParmsId;
    private final ActionSemantics.Of actionSemantics;
    private transient ObjectAction action;

    public ActionMemento(ObjectAction action) {
        this(action.getOnType().getSpecId(), action.getType(), action.getIdentifier().toNameParmsIdentityString(), action);
    }

    public ActionMemento(ObjectSpecId owningType, ActionType actionType, String nameParmsId, SpecificationLoader specificationLoader) {
        this(owningType, actionType, nameParmsId, ActionMemento.actionFor(owningType, actionType, nameParmsId, specificationLoader));
    }

    private ActionMemento(ObjectSpecId owningSpecId, ActionType actionType, String nameParmsId, ObjectAction action) {
        this.owningType = owningSpecId;
        this.actionType = actionType;
        this.nameParmsId = nameParmsId;
        this.action = action;
        this.actionSemantics = action.getSemantics();
    }

    public ObjectSpecId getOwningType() {
        return this.owningType;
    }

    public ActionType getActionType() {
        return this.actionType;
    }

    public String getNameParmsId() {
        return this.nameParmsId;
    }

    public AdapterManager.ConcurrencyChecking getConcurrencyChecking() {
        return AdapterManager.ConcurrencyChecking.concurrencyCheckingFor((ActionSemantics.Of)this.actionSemantics);
    }

    public ObjectAction getAction(SpecificationLoader specificationLoader) {
        if (this.action == null) {
            this.action = ActionMemento.actionFor(this.owningType, this.actionType, this.nameParmsId, specificationLoader);
        }
        return this.action;
    }

    private static ObjectAction actionFor(ObjectSpecId owningType, ActionType actionType, String nameParmsId, SpecificationLoader specificationLoader) {
        ObjectSpecification objectSpec = SpecUtils.getSpecificationFor(owningType, specificationLoader);
        return objectSpec.getObjectAction(actionType, nameParmsId);
    }
}

