/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.model.hints;

import org.apache.isis.viewer.wicket.model.hints.HasUiHintDisambiguator;
import org.apache.wicket.Component;
import org.apache.wicket.model.IModel;
import org.apache.wicket.util.string.PrependingStringBuffer;
import org.apache.wicket.util.string.Strings;

public interface UiHintContainer {
    public String getHint(Component var1, String var2);

    public void setHint(Component var1, String var2, String var3);

    public void clearHint(Component var1, String var2);

    public static class Util {
        private Util() {
        }

        public static UiHintContainer hintContainerOf(Component component) {
            return Util.hintContainerOf(component, UiHintContainer.class);
        }

        public static <T extends UiHintContainer> T hintContainerOf(Component component, Class<T> additionalConstraint) {
            if (component == null) {
                return null;
            }
            IModel model = component.getDefaultModel();
            if (model != null && additionalConstraint.isAssignableFrom(model.getClass())) {
                return (T)((UiHintContainer)additionalConstraint.cast(model));
            }
            return Util.hintContainerOf((Component)component.getParent(), additionalConstraint);
        }

        public static String hintPathFor(Component component) {
            String fullHintPath = Util.fullHintPathFor(component);
            String firstPathComponent = Strings.afterFirstPathComponent((String)fullHintPath, (char)':');
            return firstPathComponent;
        }

        private static String fullHintPathFor(Component component) {
            PrependingStringBuffer buffer = new PrependingStringBuffer(32);
            for (Component c = component; c != null; c = c.getParent()) {
                Class<?> aClass;
                if (buffer.length() > 0) {
                    buffer.prepend(':');
                }
                if (HasUiHintDisambiguator.class.isAssignableFrom(aClass = c.getClass())) {
                    HasUiHintDisambiguator hasUiHintDisambiguator = (HasUiHintDisambiguator)c;
                    buffer.prepend(hasUiHintDisambiguator.getHintDisambiguator());
                    buffer.prepend("-");
                }
                buffer.prepend(c.getId());
            }
            String fullHintPath = buffer.toString();
            return fullHintPath;
        }
    }
}

