/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.viewer.registries.components;

import com.google.common.base.Supplier;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.inject.Singleton;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.inject.Inject;
import org.apache.isis.viewer.wicket.ui.ComponentFactory;
import org.apache.isis.viewer.wicket.ui.ComponentType;
import org.apache.isis.viewer.wicket.ui.app.registry.ComponentFactoryRegistrar;
import org.apache.isis.viewer.wicket.ui.app.registry.ComponentFactoryRegistry;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.model.IModel;

@Singleton
public class ComponentFactoryRegistryDefault
implements ComponentFactoryRegistry {
    private final Multimap<ComponentType, ComponentFactory> componentFactoriesByType = Multimaps.newListMultimap(new HashMap(), (Supplier)new Supplier<List<ComponentFactory>>(){

        public List<ComponentFactory> get() {
            return Lists.newArrayList();
        }
    });

    @Inject
    public ComponentFactoryRegistryDefault(ComponentFactoryRegistrar componentFactoryList) {
        this.registerComponentFactories(componentFactoryList);
    }

    protected void registerComponentFactories(ComponentFactoryRegistrar componentFactoryRegistrar) {
        ComponentFactoryRegistrar.ComponentFactoryList componentFactories = new ComponentFactoryRegistrar.ComponentFactoryList();
        componentFactoryRegistrar.addComponentFactories(componentFactories);
        for (ComponentFactory componentFactory : componentFactories) {
            this.registerComponentFactory(componentFactory);
        }
        this.ensureAllComponentTypesRegistered();
    }

    protected void registerComponentFactory(ComponentFactory componentFactory) {
        this.componentFactoriesByType.put((Object)componentFactory.getComponentType(), (Object)componentFactory);
    }

    private void ensureAllComponentTypesRegistered() {
        for (ComponentType componentType : ComponentType.values()) {
            Collection componentFactories = this.componentFactoriesByType.get((Object)componentType);
            if (!componentFactories.isEmpty()) continue;
            throw new IllegalStateException("No component factories registered for " + componentType);
        }
    }

    public Component addOrReplaceComponent(MarkupContainer markupContainer, ComponentType componentType, IModel<?> model) {
        Component component = this.createComponent(componentType, model);
        markupContainer.addOrReplace(new Component[]{component});
        return component;
    }

    public Component addOrReplaceComponent(MarkupContainer markupContainer, String id, ComponentType componentType, IModel<?> model) {
        Component component = this.createComponent(componentType, id, model);
        markupContainer.addOrReplace(new Component[]{component});
        return component;
    }

    public Component createComponent(ComponentType componentType, IModel<?> model) {
        ComponentFactory componentFactory = this.findComponentFactoryElseFailFast(componentType, model);
        Component component = componentFactory.createComponent(model);
        return component;
    }

    public Component createComponent(ComponentType componentType, String id, IModel<?> model) {
        ComponentFactory componentFactory = this.findComponentFactoryElseFailFast(componentType, model);
        Component component = componentFactory.createComponent(id, model);
        return component;
    }

    public List<ComponentFactory> findComponentFactories(ComponentType componentType, IModel<?> model) {
        Collection componentFactoryList = this.componentFactoriesByType.get((Object)componentType);
        ArrayList matching = Lists.newArrayList();
        for (ComponentFactory componentFactory : componentFactoryList) {
            ComponentFactory.ApplicationAdvice appliesTo = componentFactory.appliesTo(componentType, model);
            if (appliesTo.applies()) {
                matching.add(componentFactory);
            }
            if (!appliesTo.exclusively()) continue;
            break;
        }
        if (matching.isEmpty()) {
            matching.addAll(this.componentFactoriesByType.get((Object)ComponentType.UNKNOWN));
        }
        return matching;
    }

    public ComponentFactory findComponentFactory(ComponentType componentType, IModel<?> model) {
        List<ComponentFactory> componentFactories = this.findComponentFactories(componentType, model);
        return ComponentFactoryRegistryDefault.firstOrNull(componentFactories);
    }

    public ComponentFactory findComponentFactoryElseFailFast(ComponentType componentType, IModel<?> model) {
        ComponentFactory componentFactory = this.findComponentFactory(componentType, model);
        if (componentFactory == null) {
            throw new RuntimeException(String.format("could not find component for componentType = '%s'; model object is of type %s", componentType, model.getClass().getName()));
        }
        return componentFactory;
    }

    private static <T> T firstOrNull(Collection<T> collection) {
        Iterator<T> iterator = collection.iterator();
        return iterator.hasNext() ? (T)iterator.next() : null;
    }

    public Collection<ComponentFactory> listComponentFactories() {
        return this.componentFactoriesByType.values();
    }
}

