/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.viewer.integration.wicket;

import java.util.Arrays;
import java.util.List;
import org.apache.isis.applib.clock.Clock;
import org.apache.isis.applib.services.session.SessionLoggingService;
import org.apache.isis.core.commons.authentication.AuthenticationSession;
import org.apache.isis.core.runtime.authentication.AuthenticationManager;
import org.apache.isis.core.runtime.authentication.AuthenticationRequest;
import org.apache.isis.core.runtime.authentication.AuthenticationRequestPassword;
import org.apache.isis.core.runtime.system.context.IsisContext;
import org.apache.isis.core.runtime.system.session.IsisSessionFactory;
import org.apache.isis.viewer.wicket.model.models.BookmarkedPagesModel;
import org.apache.isis.viewer.wicket.ui.components.widgets.breadcrumbs.BreadcrumbModel;
import org.apache.isis.viewer.wicket.ui.components.widgets.breadcrumbs.BreadcrumbModelProvider;
import org.apache.isis.viewer.wicket.ui.pages.BookmarkedPagesModelProvider;
import org.apache.wicket.Session;
import org.apache.wicket.authroles.authentication.AuthenticatedWebSession;
import org.apache.wicket.authroles.authorization.strategies.role.Roles;
import org.apache.wicket.request.Request;
import org.apache.wicket.request.cycle.RequestCycle;

public class AuthenticatedWebSessionForIsis
extends AuthenticatedWebSession
implements BreadcrumbModelProvider,
BookmarkedPagesModelProvider {
    private static final long serialVersionUID = 1L;
    public static final String USER_ROLE = "org.apache.isis.viewer.wicket.roles.USER";
    private final BookmarkedPagesModel bookmarkedPagesModel = new BookmarkedPagesModel();
    private final BreadcrumbModel breadcrumbModel = new BreadcrumbModel();
    private AuthenticationSession authenticationSession;

    public static AuthenticatedWebSessionForIsis get() {
        return (AuthenticatedWebSessionForIsis)Session.get();
    }

    public AuthenticatedWebSessionForIsis(Request request) {
        super(request);
    }

    public synchronized boolean authenticate(String username, String password) {
        AuthenticationRequestPassword authenticationRequest = new AuthenticationRequestPassword(username, password);
        authenticationRequest.setRoles(Arrays.asList(USER_ROLE));
        this.authenticationSession = this.getAuthenticationManager().authenticate((AuthenticationRequest)authenticationRequest);
        if (this.authenticationSession != null) {
            this.log(SessionLoggingService.Type.LOGIN, username, null);
            return true;
        }
        return false;
    }

    public synchronized void invalidateNow() {
        this.getAuthenticationManager().closeSession(this.authenticationSession);
        this.getIsisSessionFactory().closeSession();
        super.invalidateNow();
    }

    public synchronized void onInvalidate() {
        super.onInvalidate();
        SessionLoggingService.CausedBy causedBy = RequestCycle.get() != null ? SessionLoggingService.CausedBy.USER : SessionLoggingService.CausedBy.SESSION_EXPIRATION;
        String userName = null;
        if (this.authenticationSession != null) {
            userName = this.authenticationSession.getUserName();
        }
        this.log(SessionLoggingService.Type.LOGOUT, userName, causedBy);
    }

    public synchronized AuthenticationSession getAuthenticationSession() {
        return this.authenticationSession;
    }

    public synchronized Roles getRoles() {
        if (!this.isSignedIn()) {
            return null;
        }
        List roles = this.authenticationSession.getRoles();
        return new Roles(roles.toArray(new String[roles.size()]));
    }

    public synchronized void detach() {
        this.breadcrumbModel.detach();
        super.detach();
    }

    public BreadcrumbModel getBreadcrumbModel() {
        return this.breadcrumbModel;
    }

    public BookmarkedPagesModel getBookmarkedPagesModel() {
        return this.bookmarkedPagesModel;
    }

    protected AuthenticationManager getAuthenticationManager() {
        return this.getIsisSessionFactory().getAuthenticationManager();
    }

    private void log(final SessionLoggingService.Type type, final String username, final SessionLoggingService.CausedBy causedBy) {
        final SessionLoggingService sessionLoggingService = this.getSessionLoggingService();
        if (sessionLoggingService != null) {
            this.getIsisSessionFactory().doInSession(new Runnable(){

                @Override
                public void run() {
                    int sessionHashCode = System.identityHashCode((Object)AuthenticatedWebSessionForIsis.this);
                    sessionLoggingService.log(type, username, Clock.getTimeAsDateTime().toDate(), causedBy, Integer.toString(sessionHashCode));
                }
            });
        }
    }

    protected SessionLoggingService getSessionLoggingService() {
        return (SessionLoggingService)this.getIsisSessionFactory().getServicesInjector().lookupService(SessionLoggingService.class);
    }

    public synchronized void replaceSession() {
    }

    IsisSessionFactory getIsisSessionFactory() {
        return IsisContext.getSessionFactory();
    }
}

