/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.viewer;

import com.google.inject.AbstractModule;
import com.google.inject.Provider;
import com.google.inject.name.Names;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.net.MalformedURLException;
import java.net.URL;
import javax.servlet.ServletContext;
import org.apache.isis.applib.services.email.EmailService;
import org.apache.isis.applib.services.userreg.EmailNotificationService;
import org.apache.isis.core.commons.config.IsisConfiguration;
import org.apache.isis.core.runtime.services.email.EmailServiceDefault;
import org.apache.isis.core.runtime.services.userreg.EmailNotificationServiceDefault;
import org.apache.isis.viewer.wicket.model.isis.WicketViewerSettings;
import org.apache.isis.viewer.wicket.model.models.ImageResourceCache;
import org.apache.isis.viewer.wicket.ui.app.registry.ComponentFactoryRegistrar;
import org.apache.isis.viewer.wicket.ui.app.registry.ComponentFactoryRegistry;
import org.apache.isis.viewer.wicket.ui.pages.EmailVerificationUrlService;
import org.apache.isis.viewer.wicket.ui.pages.PageClassList;
import org.apache.isis.viewer.wicket.ui.pages.PageClassRegistry;
import org.apache.isis.viewer.wicket.ui.pages.PageNavigationService;
import org.apache.isis.viewer.wicket.ui.pages.accmngt.EmailVerificationUrlServiceDefault;
import org.apache.isis.viewer.wicket.viewer.IsisWicketApplication;
import org.apache.isis.viewer.wicket.viewer.imagecache.ImageResourceCacheClassPath;
import org.apache.isis.viewer.wicket.viewer.registries.components.ComponentFactoryRegistrarDefault;
import org.apache.isis.viewer.wicket.viewer.registries.components.ComponentFactoryRegistryDefault;
import org.apache.isis.viewer.wicket.viewer.registries.pages.PageClassListDefault;
import org.apache.isis.viewer.wicket.viewer.registries.pages.PageClassRegistryDefault;
import org.apache.isis.viewer.wicket.viewer.registries.pages.PageNavigationServiceDefault;
import org.apache.isis.viewer.wicket.viewer.settings.WicketViewerSettingsDefault;

public class IsisWicketModule
extends AbstractModule {
    private ServletContext servletContext;
    private IsisConfiguration isisConfigIfAny;

    public IsisWicketModule(ServletContext servletContext, IsisConfiguration isisConfigurationIfAny) {
        this.servletContext = servletContext;
        this.isisConfigIfAny = isisConfigurationIfAny;
    }

    protected void configure() {
        this.bind(ComponentFactoryRegistry.class).to(ComponentFactoryRegistryDefault.class);
        this.bind(PageClassRegistry.class).to(PageClassRegistryDefault.class);
        this.bind(EmailVerificationUrlService.class).to(EmailVerificationUrlServiceDefault.class);
        this.bind(PageNavigationService.class).to(PageNavigationServiceDefault.class);
        this.bind(PageClassList.class).to(PageClassListDefault.class);
        this.bind(ComponentFactoryRegistrar.class).to(ComponentFactoryRegistrarDefault.class);
        this.bind(ImageResourceCache.class).to(ImageResourceCacheClassPath.class);
        this.bind(WicketViewerSettings.class).to(WicketViewerSettingsDefault.class);
        this.bind(EmailService.class).to(EmailServiceDefault.class);
        this.bind(EmailNotificationService.class).to(EmailNotificationServiceDefault.class);
        if (this.isisConfigIfAny != null) {
            this.bind(String.class).annotatedWith((Annotation)Names.named((String)"applicationName")).toProvider((Provider)new Provider<String>(){

                public String get() {
                    return IsisWicketModule.this.isisConfigIfAny.getString("isis.viewer.wicket.application.name", "Apache Isis \u2122");
                }
            });
            this.bind(String.class).annotatedWith((Annotation)Names.named((String)"brandLogoHeader")).toProvider((Provider)new Provider<String>(){

                public String get() {
                    return IsisWicketModule.this.isisConfigIfAny.getString("isis.viewer.wicket.application.brandLogoHeader");
                }
            });
            this.bind(String.class).annotatedWith((Annotation)Names.named((String)"brandLogoSignin")).toProvider((Provider)new Provider<String>(){

                public String get() {
                    return IsisWicketModule.this.isisConfigIfAny.getString("isis.viewer.wicket.application.brandLogoSignin");
                }
            });
            this.bind(String.class).annotatedWith((Annotation)Names.named((String)"applicationCss")).toProvider((Provider)new Provider<String>(){

                public String get() {
                    return IsisWicketModule.this.isisConfigIfAny.getString("isis.viewer.wicket.application.css", "css/application.css");
                }
            });
            this.bind(String.class).annotatedWith((Annotation)Names.named((String)"applicationJs")).toProvider((Provider)new Provider<String>(){

                public String get() {
                    return IsisWicketModule.this.isisConfigIfAny.getString("isis.viewer.wicket.application.js", "css/application.js");
                }
            });
            this.bind(String.class).annotatedWith((Annotation)Names.named((String)"aboutMessage")).toProvider((Provider)new Provider<String>(){

                public String get() {
                    return IsisWicketModule.this.isisConfigIfAny.getString("isis.viewer.wicket.application.about", IsisWicketModule.this.isisConfigIfAny.getString("isis.viewer.wicket.application.name"));
                }
            });
            final String welcomeFile = this.isisConfigIfAny.getString("isis.viewer.wicket.welcome.file", "welcome.html");
            this.bind(String.class).annotatedWith((Annotation)Names.named((String)"welcomeMessage")).toProvider((Provider)new Provider<String>(){

                public String get() {
                    String fallback = IsisWicketModule.this.isisConfigIfAny.getString("isis.viewer.wicket.welcome.text");
                    try {
                        URL resource = IsisWicketModule.this.servletContext.getResource(IsisWicketModule.prefix("/", welcomeFile));
                        return IsisWicketApplication.readLines(resource, fallback);
                    }
                    catch (MalformedURLException e) {
                        return fallback;
                    }
                }
            });
            this.bind(String.class).annotatedWith((Annotation)Names.named((String)"applicationVersion")).toProvider((Provider)new Provider<String>(){

                public String get() {
                    return IsisWicketModule.this.isisConfigIfAny.getString("isis.viewer.wicket.application.version");
                }
            });
        }
        this.bind(InputStream.class).annotatedWith((Annotation)Names.named((String)"metaInfManifest")).toProvider((Provider)new Provider<InputStream>(){

            public InputStream get() {
                return IsisWicketModule.this.servletContext.getResourceAsStream("/META-INF/MANIFEST.MF");
            }
        });
    }

    private static String prefix(String prefix, String text) {
        return text.startsWith(prefix) ? text : prefix + text;
    }
}

