/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.viewer;

import com.google.common.base.Charsets;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.io.Resources;
import com.google.inject.Guice;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Module;
import de.agilecoders.wicket.core.Bootstrap;
import de.agilecoders.wicket.core.markup.html.bootstrap.behavior.BootstrapBaseBehavior;
import de.agilecoders.wicket.core.settings.BootstrapSettings;
import de.agilecoders.wicket.core.settings.IBootstrapSettings;
import de.agilecoders.wicket.core.settings.ThemeProvider;
import de.agilecoders.wicket.themes.markup.html.bootswatch.BootswatchTheme;
import de.agilecoders.wicket.themes.markup.html.bootswatch.BootswatchThemeProvider;
import de.agilecoders.wicket.webjars.WicketWebjars;
import de.agilecoders.wicket.webjars.settings.IWebjarsSettings;
import de.agilecoders.wicket.webjars.settings.WebjarsSettings;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import javax.servlet.ServletContext;
import net.ftlines.wicketsource.WicketSource;
import org.apache.isis.core.commons.authentication.AuthenticationSession;
import org.apache.isis.core.commons.config.IsisConfiguration;
import org.apache.isis.core.commons.config.IsisConfigurationDefault;
import org.apache.isis.core.commons.configbuilder.IsisConfigurationBuilder;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.deployment.DeploymentCategory;
import org.apache.isis.core.metamodel.specloader.validator.MetaModelInvalidException;
import org.apache.isis.core.runtime.logging.IsisLoggingConfigurer;
import org.apache.isis.core.runtime.runner.IsisInjectModule;
import org.apache.isis.core.runtime.system.DeploymentType;
import org.apache.isis.core.runtime.system.context.IsisContext;
import org.apache.isis.core.runtime.system.session.IsisSessionFactory;
import org.apache.isis.core.runtime.threadpool.ThreadPoolSupport;
import org.apache.isis.core.webapp.IsisWebAppBootstrapper;
import org.apache.isis.core.webapp.WebAppConstants;
import org.apache.isis.viewer.wicket.model.isis.WicketViewerSettings;
import org.apache.isis.viewer.wicket.model.isis.WicketViewerSettingsAccessor;
import org.apache.isis.viewer.wicket.model.mementos.ObjectAdapterMemento;
import org.apache.isis.viewer.wicket.model.models.ImageResourceCache;
import org.apache.isis.viewer.wicket.model.models.PageType;
import org.apache.isis.viewer.wicket.ui.ComponentFactory;
import org.apache.isis.viewer.wicket.ui.app.registry.ComponentFactoryRegistry;
import org.apache.isis.viewer.wicket.ui.app.registry.ComponentFactoryRegistryAccessor;
import org.apache.isis.viewer.wicket.ui.components.actionmenu.entityactions.AdditionalLinksPanel;
import org.apache.isis.viewer.wicket.ui.components.scalars.string.MultiLineStringPanel;
import org.apache.isis.viewer.wicket.ui.components.widgets.select2.Select2BootstrapCssReference;
import org.apache.isis.viewer.wicket.ui.components.widgets.select2.Select2JsReference;
import org.apache.isis.viewer.wicket.ui.pages.PageClassRegistry;
import org.apache.isis.viewer.wicket.ui.pages.PageClassRegistryAccessor;
import org.apache.isis.viewer.wicket.ui.pages.accmngt.AccountConfirmationMap;
import org.apache.isis.viewer.wicket.ui.pages.login.WicketLogoutPage;
import org.apache.isis.viewer.wicket.ui.panels.PanelUtil;
import org.apache.isis.viewer.wicket.viewer.IsisWicketModule;
import org.apache.isis.viewer.wicket.viewer.TargetRespondListenerToResetQueryResultCache;
import org.apache.isis.viewer.wicket.viewer.integration.isis.DeploymentTypeWicketAbstract;
import org.apache.isis.viewer.wicket.viewer.integration.isis.WicketServer;
import org.apache.isis.viewer.wicket.viewer.integration.isis.WicketServerPrototype;
import org.apache.isis.viewer.wicket.viewer.integration.wicket.AuthenticatedWebSessionForIsis;
import org.apache.isis.viewer.wicket.viewer.integration.wicket.ConverterForObjectAdapter;
import org.apache.isis.viewer.wicket.viewer.integration.wicket.ConverterForObjectAdapterMemento;
import org.apache.isis.viewer.wicket.viewer.integration.wicket.WebRequestCycleForIsis;
import org.apache.isis.viewer.wicket.viewer.settings.IsisResourceSettings;
import org.apache.wicket.Application;
import org.apache.wicket.Component;
import org.apache.wicket.ConverterLocator;
import org.apache.wicket.IConverterLocator;
import org.apache.wicket.Page;
import org.apache.wicket.RuntimeConfigurationType;
import org.apache.wicket.SharedResources;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.authentication.IAuthenticationStrategy;
import org.apache.wicket.authentication.strategy.DefaultAuthenticationStrategy;
import org.apache.wicket.authroles.authentication.AuthenticatedWebApplication;
import org.apache.wicket.authroles.authentication.AuthenticatedWebSession;
import org.apache.wicket.core.request.mapper.MountedMapper;
import org.apache.wicket.devutils.debugbar.DebugBar;
import org.apache.wicket.devutils.debugbar.IDebugBarContributor;
import org.apache.wicket.devutils.debugbar.InspectorDebugPanel;
import org.apache.wicket.devutils.debugbar.PageSizeDebugPanel;
import org.apache.wicket.devutils.debugbar.SessionSizeDebugPanel;
import org.apache.wicket.devutils.debugbar.VersionDebugContributor;
import org.apache.wicket.devutils.diskstore.DebugDiskDataStore;
import org.apache.wicket.guice.GuiceComponentInjector;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.head.filter.JavaScriptFilteredIntoFooterHeaderResponse;
import org.apache.wicket.markup.html.IHeaderContributor;
import org.apache.wicket.markup.html.IHeaderResponseDecorator;
import org.apache.wicket.markup.html.WebPage;
import org.apache.wicket.protocol.http.WebApplication;
import org.apache.wicket.request.IRequestMapper;
import org.apache.wicket.request.cycle.IRequestCycleListener;
import org.apache.wicket.request.cycle.PageRequestHandlerTracker;
import org.apache.wicket.request.cycle.RequestCycleListenerCollection;
import org.apache.wicket.request.resource.CssResourceReference;
import org.apache.wicket.request.resource.ResourceReference;
import org.apache.wicket.settings.RequestCycleSettings;
import org.apache.wicket.util.IContextProvider;
import org.apache.wicket.util.convert.IConverter;
import org.apache.wicket.util.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wicketstuff.select2.ApplicationSettings;

public class IsisWicketApplication
extends AuthenticatedWebApplication
implements ComponentFactoryRegistryAccessor,
PageClassRegistryAccessor,
WicketViewerSettingsAccessor {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(IsisWicketApplication.class);
    private static final String STRIP_WICKET_TAGS_KEY = "isis.viewer.wicket.stripWicketTags";
    private static final boolean STRIP_WICKET_TAGS_DEFAULT = true;
    private static final String AJAX_DEBUG_MODE_KEY = "isis.viewer.wicket.ajaxDebugMode";
    private static final boolean AJAX_DEBUG_MODE_DEFAULT = false;
    private static final String WICKET_SOURCE_PLUGIN_KEY = "isis.viewer.wicket.wicketSourcePlugin";
    private static final boolean WICKET_SOURCE_PLUGIN_DEFAULT = false;
    private static final String WICKET_REMEMBER_ME_COOKIE_KEY = "isis.viewer.wicket.rememberMe.cookieKey";
    private static final String WICKET_REMEMBER_ME_COOKIE_KEY_DEFAULT = "isisWicketRememberMe";
    private static final String WICKET_REMEMBER_ME_ENCRYPTION_KEY = "isis.viewer.wicket.rememberMe.encryptionKey";
    public static final String ENABLE_DEVELOPMENT_UTILITIES_KEY = "isis.viewer.wicket.developmentUtilities.enable";
    public static final boolean ENABLE_DEVELOPMENT_UTILITIES_DEFAULT = false;
    public static final BootswatchTheme BOOTSWATCH_THEME_DEFAULT = BootswatchTheme.Flatly;
    private final IsisLoggingConfigurer loggingConfigurer = new IsisLoggingConfigurer();
    @Inject
    private ComponentFactoryRegistry componentFactoryRegistry;
    @Inject
    private ImageResourceCache imageCache;
    @Inject
    private WicketViewerSettings wicketViewerSettings;
    @Inject
    private PageClassRegistry pageClassRegistry;
    @Inject
    private IsisSessionFactory isisSessionFactory;
    @Inject
    private IsisConfiguration configuration;
    @Inject
    private DeploymentCategory deploymentCategory;
    @Inject
    private WicketViewerSettings settings;
    private boolean determiningConfigurationType;
    private DeploymentTypeWicketAbstract deploymentType;
    private IsisConfigurationBuilder isisConfigurationBuilder;
    protected static final Function<ComponentFactory, Iterable<CssResourceReference>> getCssResourceReferences = new Function<ComponentFactory, Iterable<CssResourceReference>>(){

        public Iterable<CssResourceReference> apply(ComponentFactory input) {
            CssResourceReference cssResourceReference = input.getCssResourceReference();
            return cssResourceReference != null ? Collections.singletonList(cssResourceReference) : Collections.emptyList();
        }
    };

    public static IsisWicketApplication get() {
        return (IsisWicketApplication)AuthenticatedWebApplication.get();
    }

    protected void internalInit() {
        this.setResourceSettings(new IsisResourceSettings((Application)this));
        super.internalInit();
    }

    public Application setAjaxRequestTargetProvider(final IContextProvider<AjaxRequestTarget, Page> ajaxRequestTargetProvider) {
        Application application = super.setAjaxRequestTargetProvider((IContextProvider)new IContextProvider<AjaxRequestTarget, Page>(){

            public AjaxRequestTarget get(Page context) {
                return this.decorate((AjaxRequestTarget)ajaxRequestTargetProvider.get((Object)context));
            }

            AjaxRequestTarget decorate(AjaxRequestTarget ajaxRequestTarget) {
                ajaxRequestTarget.registerRespondListener((AjaxRequestTarget.ITargetRespondListener)new TargetRespondListenerToResetQueryResultCache());
                return ajaxRequestTarget;
            }
        });
        return application;
    }

    private boolean addListenerToStripRemovedComponentsFromAjaxTargetResponse() {
        return this.getAjaxRequestTargetListeners().add((Object)new AjaxRequestTarget.AbstractListener(){

            public void onBeforeRespond(Map<String, Component> map, AjaxRequestTarget target) {
                ArrayList idsToRemove = Lists.newArrayList();
                Set<Map.Entry<String, Component>> entries = map.entrySet();
                for (Map.Entry<String, Component> entry : entries) {
                    Component component = entry.getValue();
                    Page page = (Page)component.findParent(Page.class);
                    if (page != null) continue;
                    idsToRemove.add(entry.getKey());
                }
                for (String id : idsToRemove) {
                    map.remove(id);
                }
            }
        });
    }

    protected void init() {
        BootswatchTheme bootswatchTheme;
        List<Future<Object>> futures = null;
        try {
            boolean enableDevUtils;
            super.init();
            futures = this.startBackgroundInitializationThreads();
            String isisConfigDir = this.getServletContext().getInitParameter("isis.config.dir");
            this.configureLogging(isisConfigDir);
            this.getRequestCycleSettings().setRenderStrategy(RequestCycleSettings.RenderStrategy.REDIRECT_TO_RENDER);
            this.getResourceSettings().setParentFolderPlaceholder("$up$");
            IsisConfigurationBuilder isisConfigurationBuilder = this.obtainConfigBuilder();
            isisConfigurationBuilder.addDefaultConfigurationResourcesAndPrimers();
            IsisConfigurationDefault configuration = isisConfigurationBuilder.getConfiguration();
            DeploymentTypeWicketAbstract deploymentType = this.determineDeploymentType(configuration.getString("isis.deploymentType"));
            RequestCycleListenerCollection requestCycleListeners = this.getRequestCycleListeners();
            IRequestCycleListener requestCycleListenerForIsis = this.newWebRequestCycleForIsis();
            requestCycleListeners.add((Object)requestCycleListenerForIsis);
            requestCycleListeners.add((Object)new PageRequestHandlerTracker());
            DeploymentCategory deploymentCategory = deploymentType.getDeploymentCategory();
            IsisInjectModule isisModule = this.newIsisModule(deploymentCategory, configuration);
            Injector injector = Guice.createInjector((Module[])new Module[]{isisModule, this.newIsisWicketModule((IsisConfiguration)configuration)});
            this.initWicketComponentInjection(injector);
            injector.injectMembers((Object)this);
            this.getServletContext().setAttribute(WebAppConstants.ISIS_SESSION_FACTORY, (Object)this.isisSessionFactory);
            if (requestCycleListenerForIsis instanceof WebRequestCycleForIsis) {
                WebRequestCycleForIsis webRequestCycleForIsis = (WebRequestCycleForIsis)requestCycleListenerForIsis;
                webRequestCycleForIsis.setPageClassRegistry(this.pageClassRegistry);
            }
            this.getMarkupSettings().setStripWicketTags(this.determineStripWicketTags((IsisConfiguration)configuration));
            this.configureSecurity((IsisConfiguration)configuration);
            this.getDebugSettings().setAjaxDebugModeEnabled(this.determineAjaxDebugModeEnabled((IsisConfiguration)configuration));
            this.buildCssBundle();
            this.filterJavascriptContributions();
            this.configureWicketSourcePluginIfNecessary();
            int maxEntries = 1000;
            this.setMetaData(AccountConfirmationMap.KEY, new AccountConfirmationMap(maxEntries, Duration.days((int)1)));
            this.mountPages();
            SharedResources sharedResources = this.getSharedResources();
            MetaModelInvalidException mmie = IsisContext.getMetaModelInvalidExceptionIfAny();
            if (mmie != null) {
                this.log(mmie.getValidationErrors());
            }
            if (this.getDeploymentCategory().isPrototyping()) {
                DebugDiskDataStore.register((Application)this);
                LOG.debug("DebugDiskDataStore registered; access via ~/wicket/internal/debug/diskDataStore");
                LOG.debug("DebugDiskDataStore: eg, http://localhost:8080/wicket/wicket/internal/debug/diskDataStore");
            }
            if (!this.getDebugSettings().isDevelopmentUtilitiesEnabled() && (enableDevUtils = configuration.getBoolean(ENABLE_DEVELOPMENT_UTILITIES_KEY, false))) {
                this.getDebugSettings().setDevelopmentUtilitiesEnabled(true);
                DebugBar.registerContributor((IDebugBarContributor)VersionDebugContributor.DEBUG_BAR_CONTRIB, (Application)this);
                DebugBar.registerContributor((IDebugBarContributor)InspectorDebugPanel.DEBUG_BAR_CONTRIB, (Application)this);
                DebugBar.registerContributor((IDebugBarContributor)SessionSizeDebugPanel.DEBUG_BAR_CONTRIB, (Application)this);
                DebugBar.registerContributor((IDebugBarContributor)PageSizeDebugPanel.DEBUG_BAR_CONTRIB, (Application)this);
            }
            LOG.debug("storeSettings.inmemoryCacheSize        : {}", (Object)this.getStoreSettings().getInmemoryCacheSize());
            LOG.debug("storeSettings.asynchronousQueueCapacity: {}", (Object)this.getStoreSettings().getAsynchronousQueueCapacity());
            LOG.debug("storeSettings.maxSizePerSession        : {}", (Object)this.getStoreSettings().getMaxSizePerSession());
            LOG.debug("storeSettings.fileStoreFolder          : {}", (Object)this.getStoreSettings().getFileStoreFolder());
        }
        catch (RuntimeException ex) {
            LOG.error("Failed to initialize", (Throwable)ex);
            throw ex;
        }
        finally {
            ThreadPoolSupport.getInstance().join(futures);
        }
        String themeName = this.configuration.getString("isis.viewer.wicket.themes.initial", BOOTSWATCH_THEME_DEFAULT.name());
        try {
            bootswatchTheme = BootswatchTheme.valueOf((String)themeName);
        }
        catch (Exception ex) {
            bootswatchTheme = BOOTSWATCH_THEME_DEFAULT;
            LOG.warn("Did not recognise configured bootswatch theme '{}', defaulting to '{}'", (Object)bootswatchTheme);
        }
        IBootstrapSettings settings = Bootstrap.getSettings();
        settings.setThemeProvider((ThemeProvider)new BootswatchThemeProvider(bootswatchTheme));
    }

    protected List<Future<Object>> startBackgroundInitializationThreads() {
        return ThreadPoolSupport.getInstance().invokeAll(new Callable[]{new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                IsisWicketApplication.this.configureWebJars();
                return null;
            }

            public String toString() {
                return "configureWebJars()";
            }
        }, new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                IsisWicketApplication.this.configureWicketBootstrap();
                return null;
            }

            public String toString() {
                return "configureWicketBootstrap()";
            }
        }, new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                IsisWicketApplication.this.configureWicketSelect2();
                return null;
            }

            public String toString() {
                return "configureWicketSelect2()";
            }
        }});
    }

    protected void configureSecurity(IsisConfiguration configuration) {
        this.getSecuritySettings().setAuthenticationStrategy(this.newAuthenticationStrategy(configuration));
    }

    protected IAuthenticationStrategy newAuthenticationStrategy(IsisConfiguration configuration) {
        String cookieKey = configuration.getString(WICKET_REMEMBER_ME_COOKIE_KEY, WICKET_REMEMBER_ME_COOKIE_KEY_DEFAULT);
        String encryptionKey = configuration.getString(WICKET_REMEMBER_ME_ENCRYPTION_KEY, this.defaultEncryptionKeyIfNotConfigured());
        return new DefaultAuthenticationStrategy(cookieKey, encryptionKey);
    }

    protected String defaultEncryptionKeyIfNotConfigured() {
        return this.getDeploymentCategory().isProduction() ? UUID.randomUUID().toString() : "PrototypingEncryptionKey";
    }

    private void log(Set<String> validationErrors) {
        IsisWicketApplication.log("");
        IsisWicketApplication.logBanner();
        IsisWicketApplication.log("");
        for (String validationError : validationErrors) {
            this.logError(validationError);
        }
        IsisWicketApplication.log("");
        IsisWicketApplication.log("Please inspect the above messages and correct your domain model.");
        IsisWicketApplication.log("");
        IsisWicketApplication.logBanner();
        IsisWicketApplication.log("");
    }

    private void configureWicketSelect2() {
        ApplicationSettings select2Settings = ApplicationSettings.get();
        select2Settings.setCssReference((ResourceReference)new Select2BootstrapCssReference());
        select2Settings.setJavaScriptReference((ResourceReference)new Select2JsReference());
    }

    protected void configureWicketSourcePluginIfNecessary() {
        if (this.isWicketSourcePluginEnabled(this.configuration)) {
            this.configureWicketSourcePlugin();
        }
    }

    protected void configureWicketSourcePlugin() {
        if (!this.deploymentCategory.isProduction()) {
            WicketSource.configure((Application)this);
        }
    }

    protected static String readLines(Class<?> contextClass, String resourceName, String fallback) {
        if (resourceName == null) {
            return fallback;
        }
        URL resource = Resources.getResource(contextClass, (String)resourceName);
        return IsisWicketApplication.readLines(resource, fallback);
    }

    protected static String readLines(URL resource, String fallback) {
        try {
            List readLines = Resources.readLines((URL)resource, (Charset)Charsets.UTF_8);
            return Joiner.on((String)"\n").join((Iterable)readLines);
        }
        catch (IOException | IllegalArgumentException e) {
            return fallback;
        }
    }

    protected void configureWebJars() {
        WebjarsSettings settings = new WebjarsSettings();
        WicketWebjars.install((WebApplication)this, (IWebjarsSettings)settings);
    }

    protected void configureWicketBootstrap() {
        BootstrapSettings settings = new BootstrapSettings();
        settings.setDeferJavascript(false);
        Bootstrap.install((Application)this, (IBootstrapSettings)settings);
        this.getHeaderContributorListeners().add((Object)new IHeaderContributor((IBootstrapSettings)settings){
            final /* synthetic */ IBootstrapSettings val$settings;
            {
                this.val$settings = iBootstrapSettings;
            }

            public void renderHead(IHeaderResponse response) {
                BootstrapBaseBehavior bootstrapBaseBehavior = new BootstrapBaseBehavior();
                bootstrapBaseBehavior.renderHead(this.val$settings, response);
            }
        });
    }

    protected void configureLogging(String isisConfigDir) {
        String loggingPropertiesDir = isisConfigDir != null ? isisConfigDir : this.getServletContext().getRealPath("/WEB-INF");
        this.loggingConfigurer.configureLogging(loggingPropertiesDir, new String[0]);
    }

    protected IRequestCycleListener newWebRequestCycleForIsis() {
        return new WebRequestCycleForIsis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void determineDeploymentTypeIfRequired() {
        if (this.deploymentType != null) {
            return;
        }
        this.determiningConfigurationType = true;
        try {
            IsisConfigurationBuilder isisConfigurationBuilder = this.obtainConfigBuilder();
            IsisConfiguration configuration = isisConfigurationBuilder.peekConfiguration();
            String deploymentTypeFromConfig = configuration.getString("isis.deploymentType");
            this.deploymentType = this.determineDeploymentType(deploymentTypeFromConfig);
        }
        finally {
            this.determiningConfigurationType = false;
        }
    }

    protected DeploymentTypeWicketAbstract determineDeploymentType(String deploymentTypeFromConfig) {
        WicketServerPrototype prototype = new WicketServerPrototype();
        WicketServer deployment = new WicketServer();
        if (deploymentTypeFromConfig != null) {
            DeploymentType deploymentType = DeploymentType.lookup((String)deploymentTypeFromConfig);
            return !deploymentType.getDeploymentCategory().isProduction() ? prototype : deployment;
        }
        return this.usesDevelopmentConfig() ? prototype : deployment;
    }

    protected IsisConfigurationBuilder obtainConfigBuilder() {
        return this.isisConfigurationBuilder != null ? this.isisConfigurationBuilder : (this.isisConfigurationBuilder = IsisWebAppBootstrapper.obtainConfigBuilderFrom((ServletContext)this.getServletContext()));
    }

    protected Module newIsisWicketModule(IsisConfiguration isisConfiguration) {
        return new IsisWicketModule(this.getServletContext(), isisConfiguration);
    }

    protected Module newIsisWicketModule() {
        return this.newIsisWicketModule(null);
    }

    protected void buildCssBundle() {
        Set<CssResourceReference> references = this.cssResourceReferencesForAllComponents();
        this.addSpecialCasesToCssBundle(references);
        this.getResourceBundles().addCssBundle(IsisWicketApplication.class, "isis-wicket-viewer-bundle.css", references.toArray(new CssResourceReference[0]));
    }

    protected void addSpecialCasesToCssBundle(Set<CssResourceReference> references) {
        references.add(PanelUtil.cssResourceReferenceFor(AdditionalLinksPanel.class));
        references.add(PanelUtil.cssResourceReferenceFor(MultiLineStringPanel.class));
    }

    protected Set<CssResourceReference> cssResourceReferencesForAllComponents() {
        return Sets.newLinkedHashSet();
    }

    protected void filterJavascriptContributions() {
        this.setHeaderResponseDecorator(new IHeaderResponseDecorator(){

            public IHeaderResponse decorate(IHeaderResponse response) {
                return new JavaScriptFilteredIntoFooterHeaderResponse(response, "footerJS");
            }
        });
    }

    protected void mountPages() {
        this.mountPage("/signin", PageType.SIGN_IN);
        this.mountPage("/signup", PageType.SIGN_UP);
        this.mountPage("/signup/verify", PageType.SIGN_UP_VERIFY);
        this.mountPage("/password/reset", PageType.PASSWORD_RESET);
        this.mountPage("/entity/#{objectOid}", PageType.ENTITY);
        this.mountPage("/action/${objectOid}/${actionOwningSpec}/${actionId}/${actionType}", PageType.ACTION_PROMPT);
        this.mountPage("/logout", WicketLogoutPage.class);
    }

    protected void mountPage(String mountPath, PageType pageType) {
        Class pageClass = this.pageClassRegistry.getPageClass(pageType);
        this.mount((IRequestMapper)new MountedMapper(mountPath, pageClass));
    }

    private void logError(String validationError) {
        IsisWicketApplication.log(validationError);
    }

    private static void logBanner() {
        String msg = "################################################ ISIS METAMODEL VALIDATION ERRORS ################################################################";
        IsisWicketApplication.log(msg);
    }

    private static void log(String msg) {
        System.err.println(msg);
        LOG.error(msg);
    }

    private boolean determineStripWicketTags(IsisConfiguration configuration) {
        boolean strip = configuration.getBoolean(STRIP_WICKET_TAGS_KEY, true);
        return strip;
    }

    private boolean determineAjaxDebugModeEnabled(IsisConfiguration configuration) {
        boolean debugModeEnabled = configuration.getBoolean(AJAX_DEBUG_MODE_KEY, false);
        return debugModeEnabled;
    }

    private boolean isWicketSourcePluginEnabled(IsisConfiguration configuration) {
        boolean pluginEnabled = configuration.getBoolean(WICKET_SOURCE_PLUGIN_KEY, false);
        return pluginEnabled;
    }

    protected void onDestroy() {
        try {
            if (this.isisSessionFactory != null) {
                this.isisSessionFactory.destroyServicesAndShutdown();
            }
            this.getServletContext().setAttribute(WebAppConstants.ISIS_SESSION_FACTORY, null);
            super.onDestroy();
        }
        catch (RuntimeException ex) {
            LOG.error("Failed to destroy", (Throwable)ex);
            throw ex;
        }
    }

    public RuntimeConfigurationType getConfigurationType() {
        if (this.determiningConfigurationType) {
            return super.getConfigurationType();
        }
        this.determineDeploymentTypeIfRequired();
        return this.deploymentType.getConfigurationType();
    }

    protected IsisInjectModule newIsisModule(DeploymentCategory deploymentCategory, IsisConfigurationDefault isisConfiguration) {
        return new IsisInjectModule(deploymentCategory, isisConfiguration);
    }

    protected void initWicketComponentInjection(Injector injector) {
        this.getComponentInstantiationListeners().add((Object)new GuiceComponentInjector((Application)this, injector, false));
    }

    protected Class<? extends AuthenticatedWebSession> getWebSessionClass() {
        return AuthenticatedWebSessionForIsis.class;
    }

    protected IConverterLocator newConverterLocator() {
        ConverterLocator converterLocator = new ConverterLocator();
        converterLocator.set(ObjectAdapter.class, (IConverter)new ConverterForObjectAdapter());
        converterLocator.set(ObjectAdapterMemento.class, (IConverter)new ConverterForObjectAdapterMemento());
        return converterLocator;
    }

    public final ComponentFactoryRegistry getComponentFactoryRegistry() {
        return this.componentFactoryRegistry;
    }

    public PageClassRegistry getPageClassRegistry() {
        return this.pageClassRegistry;
    }

    public Class<? extends Page> getHomePage() {
        return this.getPageClassRegistry().getPageClass(PageType.HOME);
    }

    public Class<? extends WebPage> getSignInPageClass() {
        return this.getPageClassRegistry().getPageClass(PageType.SIGN_IN);
    }

    public Class<? extends WebPage> getSignUpPageClass() {
        return this.getPageClassRegistry().getPageClass(PageType.SIGN_UP);
    }

    public Class<? extends WebPage> getSignUpVerifyPageClass() {
        return this.getPageClassRegistry().getPageClass(PageType.SIGN_UP_VERIFY);
    }

    public Class<? extends WebPage> getForgotPasswordPageClass() {
        return this.getPageClassRegistry().getPageClass(PageType.PASSWORD_RESET);
    }

    public AuthenticationSession getAuthenticationSession() {
        return this.isisSessionFactory.getCurrentSession().getAuthenticationSession();
    }

    public DeploymentCategory getDeploymentCategory() {
        return this.deploymentCategory;
    }

    public WicketViewerSettings getSettings() {
        return this.settings;
    }
}

