/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui.util;

import com.google.common.base.Strings;
import java.io.Serializable;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.behavior.AttributeAppender;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;

public class CssClassAppender
extends AttributeAppender {
    private static final long serialVersionUID = 1L;

    public CssClassAppender(IModel<String> appendModel) {
        super("class", appendModel, " ");
    }

    public CssClassAppender(String append) {
        this((IModel<String>)Model.of((Serializable)((Object)append)));
    }

    public static void appendCssClassTo(ComponentTag tag, String cssClass) {
        if (Strings.isNullOrEmpty((String)cssClass)) {
            return;
        }
        tag.append("class", (CharSequence)cssClass, " ");
    }

    public static void appendCssClassTo(MarkupContainer markupContainer, String cssClass) {
        if (Strings.isNullOrEmpty((String)cssClass)) {
            return;
        }
        markupContainer.add(new Behavior[]{new CssClassAppender(cssClass)});
    }

    public static String asCssStyle(String str) {
        return str.replaceAll("[^A-Za-z0-9- ]", "").replaceAll("\\s+", "-");
    }
}

